/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;

class Utils {
    Utils() {
    }

    static Handler createHandler() {
        Handler handler = null;
        Looper looper = Looper.myLooper();
        if (looper != null) {
            handler = new Handler(looper);
        } else {
            looper = Looper.getMainLooper();
            if (looper != null) {
                handler = new Handler(looper);
            }
        }
        if (handler == null) {
            throw new IllegalThreadStateException("This thread must be able to obtain a Looper");
        }
        return handler;
    }

    static boolean isAudioPermissionGranted(Context context) {
        int MICROPHONE_PERMISSION = context.checkCallingOrSelfPermission("android.permission.RECORD_AUDIO");
        return MICROPHONE_PERMISSION == 0;
    }

    public static String getIPAddress(boolean useIPv4) {
        try {
            ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface intf : interfaces) {
                ArrayList<InetAddress> addrs = Collections.list(intf.getInetAddresses());
                for (InetAddress addr : addrs) {
                    boolean isIPv4;
                    if (addr.isLoopbackAddress()) continue;
                    String sAddr = addr.getHostAddress();
                    boolean bl = isIPv4 = sAddr.indexOf(58) < 0;
                    if (useIPv4) {
                        if (!isIPv4) continue;
                        return sAddr;
                    }
                    if (isIPv4) continue;
                    int delim = sAddr.indexOf(37);
                    return delim < 0 ? sAddr.toUpperCase() : sAddr.substring(0, delim).toUpperCase();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    static boolean permissionGranted(Context context, String permission2) {
        int permissionCheck = context.checkCallingOrSelfPermission(permission2);
        return permissionCheck == 0;
    }
}

