/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import android.support.annotation.Nullable;
import com.twilio.voice.Logger;
import java.io.IOException;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;

class VoiceURLConnection {
    private static final Logger logger = Logger.getLogger(VoiceURLConnection.class);
    public static final String METHOD_TYPE_POST = "POST";
    public static final String METHOD_TYPE_DELETE = "DELETE";
    private static final String HEADER_CONTENT_TYPE_KEY = "Content-Type";
    private static final String HEADER_CONTENT_TYPE_VALUE = "application/json";
    private static final String HEADER_ACCEPT_KEY = "Accept";
    private static final String HEADER_TWILIO_TOKEN_KEY = "X-Twilio-Token";
    static final int CONNECTION_TIMEOUT = 10000;
    static final int SOCKET_READ_TIMEOUT = 10000;

    private VoiceURLConnection() {
    }

    static HttpsURLConnection create(String accessToken, String hostURL, String requestMethodType) throws IOException {
        URL url = new URL(hostURL);
        HttpsURLConnection urlConnection = (HttpsURLConnection)url.openConnection();
        if (requestMethodType.equals(METHOD_TYPE_DELETE)) {
            urlConnection.setDoOutput(false);
        } else {
            urlConnection.setDoOutput(true);
        }
        urlConnection.setDoInput(true);
        urlConnection.setRequestProperty(HEADER_CONTENT_TYPE_KEY, HEADER_CONTENT_TYPE_VALUE);
        urlConnection.setRequestProperty(HEADER_ACCEPT_KEY, HEADER_CONTENT_TYPE_VALUE);
        urlConnection.setRequestProperty(HEADER_TWILIO_TOKEN_KEY, accessToken);
        urlConnection.setConnectTimeout(10000);
        urlConnection.setReadTimeout(10000);
        urlConnection.setRequestMethod(requestMethodType);
        return urlConnection;
    }

    static void release(@Nullable HttpsURLConnection urlConnection) {
        if (urlConnection != null) {
            try {
                urlConnection.getInputStream().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                urlConnection.getOutputStream().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                urlConnection.getErrorStream().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            urlConnection.disconnect();
        }
    }
}

