/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import android.content.Context;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Pair;
import com.twilio.voice.AcceptOptions;
import com.twilio.voice.CallException;
import com.twilio.voice.CallInvite;
import com.twilio.voice.ConnectOptions;
import com.twilio.voice.Constants;
import com.twilio.voice.EventPublisher;
import com.twilio.voice.InternalCall;
import com.twilio.voice.LocalAudioTrack;
import com.twilio.voice.Logger;
import com.twilio.voice.MediaFactory;
import com.twilio.voice.Preconditions;
import com.twilio.voice.StatsListener;
import com.twilio.voice.StatsReport;
import com.twilio.voice.ThreadUtils;
import com.twilio.voice.Utils;
import com.twilio.voice.Voice;
import java.util.HashMap;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class Call
extends InternalCall {
    private final ThreadUtils.ThreadChecker threadChecker;
    private Listener listener;
    private EventListener eventListener;
    private static final Logger logger = Logger.getLogger(Call.class);
    private List<LocalAudioTrack> localAudioTracks;
    private MediaFactory mediaFactory;
    private long nativeCallDelegate;
    private Queue<Pair<Handler, StatsListener>> statsListenersQueue;
    private final Listener callListenerProxy = new Listener(){

        @Override
        public void onRinging(final @NonNull Call call) {
            Call.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    Call.this.threadChecker.checkIsOnValidThread();
                    logger.d("onRinging()");
                    Call.this.state = State.RINGING;
                    call.sid = Call.this.nativeGetSid(Call.this.nativeCallDelegate);
                    Call.this.listener.onRinging(call);
                }
            });
        }

        @Override
        public void onConnected(final @NonNull Call call) {
            Call.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    Call.this.threadChecker.checkIsOnValidThread();
                    logger.d("onConnected()");
                    Call.this.state = State.CONNECTED;
                    call.sid = Call.this.nativeGetSid(Call.this.nativeCallDelegate);
                    Call.this.listener.onConnected(call);
                }
            });
        }

        @Override
        public void onConnectFailure(final @NonNull Call call, final @NonNull CallException callException) {
            Call.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    Call.this.releaseCall();
                    Call.this.threadChecker.checkIsOnValidThread();
                    logger.d("onConnectFailure()");
                    Voice.calls.remove(Call.this);
                    Voice.rejects.remove(Call.this);
                    Call.this.state = State.DISCONNECTED;
                    Call.this.release();
                    Call.this.listener.onConnectFailure(call, callException);
                }
            });
        }

        @Override
        public void onDisconnected(final @NonNull Call call, final CallException callException) {
            Call.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    Call.this.releaseCall();
                    Call.this.threadChecker.checkIsOnValidThread();
                    logger.d("onDisconnected()");
                    Voice.calls.remove(Call.this);
                    Voice.rejects.remove(Call.this);
                    Call.this.state = State.DISCONNECTED;
                    Call.this.release();
                    Call.this.listener.onDisconnected(call, callException);
                }
            });
        }
    };
    EventListener eventListenerProxy = new EventListener(){

        @Override
        public void onEvent(final HashMap<String, String> data) {
            Call.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    if (Call.this.eventListener != null) {
                        Call.this.eventListener.onEvent(data);
                    }
                    if (((String)data.get("group")).compareToIgnoreCase("ice-gathering-state") == 0) {
                        Call.this.publishIceGatheringEvent((String)data.get("name"));
                    } else if (((String)data.get("group")).compareToIgnoreCase("ice-connection-state") == 0) {
                        Call.this.publishIceConnectionEvent((String)data.get("name"));
                    } else if (((String)data.get("group")).compareToIgnoreCase("connection") == 0) {
                        if (((String)data.get("name")).compareToIgnoreCase("error") == 0) {
                            if (data.get("error_code") != null) {
                                Call.this.publishConnectionErrorEvent((String)data.get("name"), Integer.parseInt((String)data.get("error_code")), (String)data.get("error_message"));
                            }
                        } else {
                            Call.this.publishConnectionEvent((String)data.get("name"));
                        }
                    }
                }
            });
        }
    };
    private final StatsListener statsListenerProxy = new StatsListener(){

        @Override
        public void onStats(final List<StatsReport> statsReports) {
            final Pair statsPair = (Pair)Call.this.statsListenersQueue.poll();
            if (statsPair != null) {
                ((Handler)statsPair.first).post(new Runnable(){

                    @Override
                    public void run() {
                        ((StatsListener)statsPair.second).onStats(statsReports);
                    }
                });
            }
        }
    };

    Call(Context context, CallInvite callInvite, Listener listener) {
        this.context = context;
        this.listener = listener;
        this.from = callInvite.getFrom();
        this.to = callInvite.getTo();
        this.sid = callInvite.getCallSid();
        this.bridgeToken = callInvite.getBridgeToken();
        this.disconnectCalled = false;
        this.direction = Constants.Direction.INCOMING;
        this.handler = Utils.createHandler();
        this.threadChecker = new ThreadUtils.ThreadChecker(this.handler.getLooper().getThread());
        this.state = State.CONNECTING;
        this.publisher = new EventPublisher("twilio-voice-android", this.bridgeToken);
        this.publisher.addListener(this);
        this.statsListenersQueue = new ConcurrentLinkedQueue<Pair<Handler, StatsListener>>();
    }

    Call(Context context, String accessToken, Listener listener) {
        this.context = context;
        this.listener = listener;
        this.state = State.CONNECTING;
        this.direction = Constants.Direction.OUTGOING;
        this.handler = Utils.createHandler();
        this.threadChecker = new ThreadUtils.ThreadChecker(this.handler.getLooper().getThread());
        this.publisher = new EventPublisher("twilio-voice-android", accessToken);
        this.publisher.addListener(this);
        this.statsListenersQueue = new ConcurrentLinkedQueue<Pair<Handler, StatsListener>>();
    }

    @Nullable
    public String getFrom() {
        return this.from;
    }

    @Nullable
    public String getTo() {
        return this.to;
    }

    @Override
    @Nullable
    public String getSid() {
        return this.sid;
    }

    @Override
    @NonNull
    public State getState() {
        return this.state;
    }

    public synchronized void getStats(@NonNull StatsListener statsListener) {
        this.threadChecker.checkIsOnValidThread();
        Preconditions.checkNotNull(statsListener, "statsListener must not be null");
        if (this.state == State.DISCONNECTED) {
            return;
        }
        this.statsListenersQueue.offer((Pair<Handler, StatsListener>)new Pair((Object)Utils.createHandler(), (Object)statsListener));
        this.nativeGetStats(this.nativeCallDelegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connect(ConnectOptions connectOptions) {
        this.threadChecker.checkIsOnValidThread();
        Voice.calls.add(this);
        ConnectOptions.checkAudioTracksReleased(connectOptions.getAudioTracks());
        this.localAudioTracks = connectOptions.getAudioTracks();
        Listener listener = this.callListenerProxy;
        synchronized (listener) {
            Voice.loadLibrary(this.context);
            this.mediaFactory = MediaFactory.instance(this, this.context);
            if (connectOptions.getEventListener() != null) {
                this.eventListener = connectOptions.getEventListener();
            }
            this.nativeCallDelegate = this.nativeConnect(connectOptions, this.callListenerProxy, this.statsListenerProxy, this.eventListenerProxy, this.mediaFactory.getNativeMediaFactoryHandle(), this.handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void accept(AcceptOptions acceptOptions) {
        this.threadChecker.checkIsOnValidThread();
        Voice.calls.add(this);
        AcceptOptions.checkAudioTracksReleased(acceptOptions.getAudioTracks());
        this.localAudioTracks = acceptOptions.getAudioTracks();
        Listener listener = this.callListenerProxy;
        synchronized (listener) {
            Voice.loadLibrary(this.context);
            this.mediaFactory = MediaFactory.instance(this, this.context);
            if (acceptOptions.getEventListener() != null) {
                this.eventListener = acceptOptions.getEventListener();
            }
            this.nativeCallDelegate = this.nativeAccept(acceptOptions, this.callListenerProxy, this.statsListenerProxy, this.eventListenerProxy, this.mediaFactory.getNativeMediaFactoryHandle(), this.handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reject(AcceptOptions acceptOptions) {
        this.threadChecker.checkIsOnValidThread();
        Voice.rejects.add(this);
        this.localAudioTracks = acceptOptions.getAudioTracks();
        Listener listener = this.callListenerProxy;
        synchronized (listener) {
            Voice.loadLibrary(this.context);
            if (acceptOptions.getEventListener() != null) {
                this.eventListener = acceptOptions.getEventListener();
            }
            this.nativeCallDelegate = this.nativeReject(acceptOptions, this.callListenerProxy, this.eventListenerProxy, this.handler);
        }
    }

    @Override
    public synchronized void mute(boolean mute) {
        this.threadChecker.checkIsOnValidThread();
        if (this.isValidState()) {
            this.isMuted = mute;
            this.nativeMute(this.nativeCallDelegate, mute);
        }
    }

    @Override
    public synchronized void sendDigits(@NonNull String digits) {
        this.threadChecker.checkIsOnValidThread();
        Preconditions.checkNotNull(digits, "digits must not be null");
        if (!digits.matches("^[0-9\\*\\#w]+$")) {
            throw new IllegalArgumentException("digits string must not be null and should only contains 0-9, *, #, or w characters");
        }
        if (this.isValidState()) {
            this.nativeSendDigits(this.nativeCallDelegate, digits);
        }
    }

    public synchronized void hold(boolean hold) {
        this.threadChecker.checkIsOnValidThread();
        if (this.isValidState()) {
            this.isOnHold = hold;
            this.nativeHold(this.nativeCallDelegate, hold);
        }
    }

    @Override
    public boolean isMuted() {
        return this.isMuted;
    }

    public boolean isOnHold() {
        return this.isOnHold;
    }

    @Override
    public synchronized void disconnect() {
        this.threadChecker.checkIsOnValidThread();
        if (!this.disconnectCalled && this.isValidState()) {
            this.disconnectCalled = true;
            logger.d("Calling disconnect " + (Object)((Object)this.state));
            this.nativeDisconnect(this.nativeCallDelegate);
        }
    }

    synchronized void release() {
        this.threadChecker.checkIsOnValidThread();
        for (LocalAudioTrack localAudioTrack : this.localAudioTracks) {
            localAudioTrack.release();
        }
        if (this.nativeCallDelegate != 0L) {
            this.nativeRelease(this.nativeCallDelegate);
            this.nativeCallDelegate = 0L;
            if (this.mediaFactory != null) {
                this.mediaFactory.release(this);
            }
        }
    }

    private synchronized void releaseCall() {
        if (this.nativeCallDelegate != 0L) {
            this.nativeReleaseCall(this.nativeCallDelegate);
            this.cleanupStatsListenerQueue();
        }
    }

    private void cleanupStatsListenerQueue() {
    }

    private native long nativeConnect(ConnectOptions var1, Listener var2, StatsListener var3, EventListener var4, long var5, Handler var7);

    private native long nativeAccept(AcceptOptions var1, Listener var2, StatsListener var3, EventListener var4, long var5, Handler var7);

    private native long nativeReject(AcceptOptions var1, Listener var2, EventListener var3, Handler var4);

    private native String nativeGetSid(long var1);

    private native void nativeGetStats(long var1);

    private native void nativeMute(long var1, boolean var3);

    private native void nativeSendDigits(long var1, String var3);

    private native void nativeHold(long var1, boolean var3);

    private native void nativeDisconnect(long var1);

    private native void nativeReleaseCall(long var1);

    private native void nativeRelease(long var1);

    static interface EventListener {
        public void onEvent(HashMap<String, String> var1);
    }

    public static interface Listener {
        public void onConnectFailure(@NonNull Call var1, @NonNull CallException var2);

        public void onRinging(@NonNull Call var1);

        public void onConnected(@NonNull Call var1);

        public void onDisconnected(@NonNull Call var1, @Nullable CallException var2);
    }

    public static enum State {
        CONNECTING,
        RINGING,
        CONNECTED,
        DISCONNECTED;

    }
}

