/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.twilio.voice.AudioCodec;
import com.twilio.voice.Call;
import com.twilio.voice.Constants;
import com.twilio.voice.IceOptions;
import com.twilio.voice.LocalAudioTrack;
import com.twilio.voice.OpusCodec;
import com.twilio.voice.PcmuCodec;
import com.twilio.voice.PlatformInfo;
import com.twilio.voice.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class CallOptions {
    private static final Set<Class> SUPPORTED_CODECS = new HashSet<Class>(Arrays.asList(OpusCodec.class, PcmuCodec.class));
    List<LocalAudioTrack> audioTracks;
    IceOptions iceOptions;
    boolean enableInsights;
    List<AudioCodec> preferredAudioCodecs;
    PlatformInfo platformInfo;
    String region;
    Call.EventListener eventListener;

    protected static void checkAudioCodecs(@NonNull List<AudioCodec> audioCodecs) {
        for (AudioCodec audioCodec : audioCodecs) {
            Preconditions.checkNotNull(audioCodec);
            Preconditions.checkArgument(SUPPORTED_CODECS.contains(audioCodec.getClass()), String.format("Unsupported audio codec %s", audioCodec.getName()));
        }
    }

    CallOptions() {
    }

    List<LocalAudioTrack> getAudioTracks() {
        return this.audioTracks;
    }

    @Nullable
    public IceOptions getIceOptions() {
        return this.iceOptions;
    }

    @Nullable
    public List<AudioCodec> getPreferredAudioCodecs() {
        return this.preferredAudioCodecs;
    }

    boolean isInsightsEnabled() {
        return this.enableInsights;
    }

    static void checkAudioTracksReleased(@Nullable List<LocalAudioTrack> audioTracks) {
        if (audioTracks != null) {
            for (LocalAudioTrack localAudioTrack : audioTracks) {
                Preconditions.checkState(!localAudioTrack.isReleased(), "LocalAudioTrack cannot be released");
            }
        }
    }

    LocalAudioTrack[] getLocalAudioTracksArray() {
        LocalAudioTrack[] audioTracksArray = new LocalAudioTrack[]{};
        if (this.audioTracks.size() > 0) {
            audioTracksArray = new LocalAudioTrack[this.audioTracks.size()];
            audioTracksArray = this.audioTracks.toArray(audioTracksArray);
        }
        return audioTracksArray;
    }

    AudioCodec[] getAudioCodecsArray() {
        AudioCodec[] audioCodecsArray = new AudioCodec[]{};
        if (this.preferredAudioCodecs != null && !this.preferredAudioCodecs.isEmpty()) {
            audioCodecsArray = new AudioCodec[this.preferredAudioCodecs.size()];
            audioCodecsArray = this.preferredAudioCodecs.toArray(audioCodecsArray);
        }
        return audioCodecsArray;
    }

    @Nullable
    public String getRegion() {
        return this.region;
    }

    Call.EventListener getEventListener() {
        return this.eventListener;
    }

    public static abstract class Builder {
        IceOptions iceOptions;
        List<LocalAudioTrack> audioTracks;
        List<AudioCodec> preferredAudioCodecs;
        boolean enableInsights = true;
        String region = Constants.GLOBAL_LOW_LATENCY_REGION;
        Call.EventListener eventListener = null;

        Builder() {
        }

        Builder audioTracks(@NonNull List<LocalAudioTrack> audioTracks) {
            Preconditions.checkNotNull(audioTracks, "audioTracks must not be null");
            this.audioTracks = new ArrayList<LocalAudioTrack>(audioTracks);
            return this;
        }

        Builder iceOptions(@NonNull IceOptions iceOptions) {
            Preconditions.checkNotNull(iceOptions, "iceOptions must not be null");
            this.iceOptions = iceOptions;
            return this;
        }

        Builder enableInsights(boolean enable) {
            this.enableInsights = enable;
            return this;
        }

        Builder preferAudioCodecs(@NonNull List<AudioCodec> preferredAudioCodecs) {
            Preconditions.checkNotNull(preferredAudioCodecs, "preferredAudioCodecs must not be null");
            this.preferredAudioCodecs = new ArrayList<AudioCodec>(preferredAudioCodecs);
            return this;
        }

        Builder region(@NonNull String region) {
            Preconditions.checkNotNull(region, "region must not be null");
            this.region = region;
            return this;
        }

        Builder eventListener(Call.EventListener eventListener) {
            this.eventListener = eventListener;
            return this;
        }
    }
}

