/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import java.util.Map;

public class CancelledCallInvite
implements Parcelable {
    private final String from;
    private final String to;
    private final String callSid;
    public static final Parcelable.Creator CREATOR = new Parcelable.Creator(){

        public CancelledCallInvite createFromParcel(Parcel in) {
            return new CancelledCallInvite(in);
        }

        public CancelledCallInvite[] newArray(int size) {
            return new CancelledCallInvite[size];
        }
    };

    @NonNull
    public String getFrom() {
        return this.from;
    }

    @NonNull
    public String getTo() {
        return this.to;
    }

    @NonNull
    public String getCallSid() {
        return this.callSid;
    }

    static CancelledCallInvite create(Map<String, String> data) {
        return new CancelledCallInvite(data);
    }

    private CancelledCallInvite(Map<String, String> data) {
        this.from = data.get("twi_from");
        this.to = data.get("twi_to");
        this.callSid = data.get("twi_call_sid");
    }

    private CancelledCallInvite(Parcel in) {
        String[] data = new String[3];
        in.readStringArray(data);
        this.from = data[0];
        this.to = data[1];
        this.callSid = data[2];
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeStringArray(new String[]{this.from, this.to, this.callSid});
    }

    static boolean isValid(Map<String, String> data) {
        String messageType = data.get("twi_message_type");
        String callSid = data.get("twi_call_sid");
        String from = data.get("twi_from");
        String to = data.get("twi_to");
        return messageType != null && messageType.equals("twilio.voice.cancel") && callSid != null && from != null && to != null;
    }

    public boolean equals(Object o) {
        if (o instanceof CancelledCallInvite) {
            CancelledCallInvite cancelledCallInvite = (CancelledCallInvite)o;
            return this.getFrom().equals(cancelledCallInvite.getFrom()) && this.getTo().equals(cancelledCallInvite.getTo()) && this.getCallSid().equals(cancelledCallInvite.getCallSid());
        }
        return false;
    }
}

