/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import android.support.annotation.NonNull;
import com.twilio.voice.AudioCodec;
import com.twilio.voice.Call;
import com.twilio.voice.CallOptions;
import com.twilio.voice.IceOptions;
import com.twilio.voice.LocalAudioTrack;
import com.twilio.voice.PlatformInfo;
import com.twilio.voice.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConnectOptions
extends CallOptions {
    private final String accessToken;
    private final Map<String, String> params;

    private ConnectOptions() {
        this.accessToken = "";
        this.params = new HashMap<String, String>();
    }

    private ConnectOptions(Builder builder) {
        this.accessToken = builder.accessToken;
        this.audioTracks = builder.audioTracks != null ? builder.audioTracks : new ArrayList();
        this.iceOptions = builder.iceOptions;
        this.enableInsights = builder.enableInsights;
        this.preferredAudioCodecs = builder.preferredAudioCodecs;
        this.params = builder.params == null ? new HashMap() : builder.params;
        this.platformInfo = new PlatformInfo();
        this.region = builder.region;
        this.eventListener = builder.eventListener;
    }

    @NonNull
    public String getAccessToken() {
        return this.accessToken;
    }

    @NonNull
    public Map<String, String> getParams() {
        return this.params;
    }

    private long createNativeConnectOptionsBuilder() {
        ConnectOptions.checkAudioTracksReleased(this.audioTracks);
        boolean reject = false;
        String[] keys = new String[this.params.size()];
        String[] values = new String[this.params.size()];
        int index = 0;
        for (Map.Entry<String, String> mapEntry : this.params.entrySet()) {
            keys[index] = mapEntry.getKey();
            values[index] = mapEntry.getValue();
            ++index;
        }
        String[] callInviteMessageKeys = new String[]{};
        String[] callInviteMessageValues = new String[]{};
        return this.nativeCreate(this.accessToken, keys, values, this.getLocalAudioTracksArray(), this.iceOptions, this.enableInsights, this.getAudioCodecsArray(), callInviteMessageKeys, callInviteMessageValues, false, this.platformInfo, this.region);
    }

    private native long nativeCreate(String var1, String[] var2, String[] var3, LocalAudioTrack[] var4, IceOptions var5, boolean var6, AudioCodec[] var7, String[] var8, String[] var9, boolean var10, PlatformInfo var11, String var12);

    public static class Builder
    extends CallOptions.Builder {
        private final String accessToken;
        private Map<String, String> params;

        public Builder(@NonNull String accessToken) {
            Preconditions.checkNotNull(accessToken, "accessToken must not be null");
            this.accessToken = accessToken;
        }

        @NonNull
        public Builder params(@NonNull Map<String, String> params) {
            Preconditions.checkNotNull(params, "params must not be null");
            this.params = params;
            return this;
        }

        @Override
        @NonNull
        Builder audioTracks(@NonNull List<LocalAudioTrack> audioTracks) {
            Preconditions.checkNotNull(audioTracks, "audioTracks must not be null");
            super.audioTracks(audioTracks);
            return this;
        }

        @Override
        @NonNull
        public Builder iceOptions(@NonNull IceOptions iceOptions) {
            Preconditions.checkNotNull(iceOptions, "iceOptions must not be null");
            super.iceOptions(iceOptions);
            return this;
        }

        @Override
        Builder enableInsights(boolean enable) {
            super.enableInsights(enable);
            return this;
        }

        @Override
        @NonNull
        public Builder preferAudioCodecs(@NonNull List<AudioCodec> preferredAudioCodecs) {
            Preconditions.checkNotNull(preferredAudioCodecs, "preferredAudioCodecs must not be null");
            CallOptions.checkAudioCodecs(preferredAudioCodecs);
            super.preferAudioCodecs(preferredAudioCodecs);
            return this;
        }

        @Override
        @NonNull
        public Builder region(@NonNull String region) {
            Preconditions.checkNotNull(region, "region must not be null");
            super.region(region);
            return this;
        }

        @Override
        Builder eventListener(Call.EventListener eventListener) {
            super.eventListener(eventListener);
            return this;
        }

        @NonNull
        public ConnectOptions build() {
            CallOptions.checkAudioTracksReleased(this.audioTracks);
            if (this.params != null) {
                for (Map.Entry<String, String> entry : this.params.entrySet()) {
                    Preconditions.checkState(entry.getKey() != null, "params entry key should not be null");
                    Preconditions.checkState(entry.getValue() != null, "params entry value should not be null");
                }
            }
            return new ConnectOptions(this);
        }
    }
}

