/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Handler;
import com.twilio.voice.Logger;
import com.twilio.voice.Utils;
import com.twilio.voice.Voice;

class ConnectivityReceiver
extends BroadcastReceiver {
    private static final Logger logger = Logger.getLogger(ConnectivityReceiver.class);
    private static final int RECONNECT_THRESHOLD = 7000;
    private boolean connected = true;
    private int curNetworkType = -1;
    private int lastConnectedNetworkType = -1;
    private String lastWifiSSID;
    private long lastDisconnectTime = 0L;
    private boolean pendingNetChange;
    private Handler handler = Utils.createHandler();
    private Runnable connectivityTimeoutRunnable;

    public ConnectivityReceiver() {
        if (this.curNetworkType == -1) {
            this.lastDisconnectTime = System.currentTimeMillis();
        }
        this.connectivityTimeoutRunnable = new Runnable(){

            @Override
            public void run() {
                logger.d(String.format("Exceeded the connectivity threshold of %d seconds. Disconnecting calls.", 7000));
            }
        };
    }

    private boolean updateNetworkState(Context context) {
        boolean changed;
        int oldNetworkType = this.lastConnectedNetworkType;
        ConnectivityManager connMan = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo netInfo = connMan.getActiveNetworkInfo();
        if (netInfo != null) {
            this.lastConnectedNetworkType = this.curNetworkType = netInfo.getType();
        } else {
            this.curNetworkType = -1;
        }
        boolean bl = changed = this.curNetworkType != -1 && this.lastConnectedNetworkType != oldNetworkType;
        if (this.curNetworkType == 1) {
            WifiManager wifiMan = (WifiManager)context.getSystemService("wifi");
            WifiInfo wifiInfo = wifiMan.getConnectionInfo();
            if (wifiInfo != null) {
                String oldSSID = this.lastWifiSSID;
                this.lastWifiSSID = wifiInfo.getSSID();
                if (this.lastWifiSSID == null || !this.lastWifiSSID.equals(oldSSID)) {
                    changed = true;
                }
            } else {
                this.lastWifiSSID = null;
            }
            logger.d("got wifi SSID: " + this.lastWifiSSID);
        } else {
            this.lastWifiSSID = null;
        }
        return changed;
    }

    public void onReceive(Context context, Intent intent) {
        if (context == null) {
            return;
        }
        if (this.isInitialStickyBroadcast()) {
            logger.d("Ignoring network event, sticky broadcast");
            return;
        }
        boolean haveConnection = !intent.getBooleanExtra("noConnectivity", false);
        String reason = intent.getStringExtra("reason");
        boolean isFailover = intent.getBooleanExtra("isFailover", false);
        logger.d(String.format("got connectivity broadcast: haveConn=%b, reason=%s, isFailover=%b", haveConnection, reason, isFailover));
        boolean wasConnected = this.connected;
        this.connected = haveConnection;
        logger.v("old net type: " + this.curNetworkType);
        boolean netTypeChanged = this.updateNetworkState(context);
        logger.v("new net type: " + this.curNetworkType);
        logger.d("NET CHANGE EVENT: connected=" + haveConnection + ", wasConnected=" + wasConnected + ", netTypeChanged=" + netTypeChanged);
        if (wasConnected && !haveConnection) {
            this.lastDisconnectTime = System.currentTimeMillis();
            this.pendingNetChange = netTypeChanged;
            Voice.onNetworkChanged();
            this.handler.postDelayed(this.connectivityTimeoutRunnable, 7000L);
        } else if (!wasConnected && haveConnection && !netTypeChanged && System.currentTimeMillis() - this.lastDisconnectTime > 7000L) {
            this.handler.removeCallbacks(this.connectivityTimeoutRunnable);
            Voice.onNetworkChanged();
        } else if (netTypeChanged || this.pendingNetChange) {
            this.pendingNetChange = false;
            this.handler.removeCallbacks(this.connectivityTimeoutRunnable);
            Voice.onNetworkChanged();
        }
        if (netTypeChanged) {
            logger.d("switched networks to type " + this.curNetworkType);
        }
    }
}

