/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import android.net.Uri;
import android.os.Build;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

abstract class Constants {
    public static final Object clientStringLock = new Object();
    public static final boolean dev = true;
    private static final String KEY_CHUNDER_HOST = "chunder";
    private static final String KEY_CHUNDER_PORT = "chunder-port";
    private static final String KEY_EA_HOST = "ea-host";
    private static final String KEY_NOTIFICATION_SERVICE_HOST = "notification-service";
    private static final String TWILIO_DEFAULT_CHUNDER_PORT = "10193";
    private static final String TWILIO_DEFAULT_CHUNDER_PORT_TLS = "10194";
    private static final String KEY_KIBANA_METRICS_HOST_URL = "kibana-metrics-host";
    private static final String KEY_KIBANA_EVENT_GATEWAY_HOST_URL = "kibana-event-gateway-host";
    private static final String TWILIO_DEFAULT_KIBANA_METRICS_HOST_URL = "https://eventgw.twilio.com/v4/EndpointMetrics";
    private static final String TWILIO_DEFAULT_KIBANA_EVENT_GATEWAY_HOST_URL = "https://eventgw.twilio.com/v4/EndpointEvents";
    private static final String TWILIO_DEFAULT_EA_HOST = "eventgw.twilio.com";
    static final String TWILIO_DEFAULT_CHUNDER_HOST = "chunderm.gll.twilio.com";
    static final String TWILIO_CHUNDER_HOST_PREFIX = "chunderm.";
    static final String TWILIO_DOMAIN = ".twilio.com";
    static final String TWILIO_REQUEST_HEADER = "X-Twilio-Request-Id";
    static final String TWILIO_REQUEST_SID_PREFIX = "RQ";
    private static final String DEFAULT_NOTIFICATION_SERVICE_HOST_URL = "https://ers.twilio.com";
    static int PJMEDIA_ENOSNDREC = 220200;
    static int PJMEDIA_EAUD_INIT = 420003;
    public static volatile String clientString;
    public static boolean ALLOW_CONTACT_REWRITE_ENABLE;
    public static String GLOBAL_LOW_LATENCY_REGION;
    private static Map<String, String> params;
    public static final String CLIENT_SDK_PRODUCT_NAME = "twilio-voice-android";
    public static final String APP_JSON_PAYLOADTYPE = "application/json";
    public static final String PLATFORM_ANDROID = "android";

    Constants() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getClientString() {
        if (clientString == null) {
            Object object = clientStringLock;
            synchronized (object) {
                if (clientString == null) {
                    String sdkVersion = "3.0.0-beta2";
                    try {
                        JSONObject rootObj = new JSONObject();
                        rootObj.put("p", (Object)PLATFORM_ANDROID);
                        rootObj.put("v", (Object)sdkVersion);
                        JSONObject mobileObj = new JSONObject();
                        mobileObj.put("name", (Object)Build.PRODUCT);
                        mobileObj.put("product", (Object)(Build.MANUFACTURER + " " + Build.MODEL));
                        mobileObj.put("arch", (Object)Build.CPU_ABI);
                        mobileObj.put("v", (Object)Build.VERSION.RELEASE);
                        rootObj.put("mobile", (Object)mobileObj);
                        clientString = Uri.encode((String)rootObj.toString());
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return clientString;
    }

    public static final int getCallControlPort(boolean useTLS) {
        return Integer.parseInt(params.containsKey(KEY_CHUNDER_PORT) ? params.get(KEY_CHUNDER_PORT) : (useTLS ? TWILIO_DEFAULT_CHUNDER_PORT_TLS : TWILIO_DEFAULT_CHUNDER_PORT));
    }

    public static final String getNotificationServiceUrl() {
        return params.containsKey(KEY_NOTIFICATION_SERVICE_HOST) ? params.get(KEY_NOTIFICATION_SERVICE_HOST) : DEFAULT_NOTIFICATION_SERVICE_HOST_URL;
    }

    public static final String getKeyKibanaMetricsHostUrl() {
        return params.containsKey(KEY_KIBANA_METRICS_HOST_URL) ? params.get(KEY_KIBANA_METRICS_HOST_URL) : TWILIO_DEFAULT_KIBANA_METRICS_HOST_URL;
    }

    public static final String getKeyKibanaEventGatewayHostUrl() {
        return params.containsKey(KEY_KIBANA_EVENT_GATEWAY_HOST_URL) ? params.get(KEY_KIBANA_EVENT_GATEWAY_HOST_URL) : TWILIO_DEFAULT_KIBANA_EVENT_GATEWAY_HOST_URL;
    }

    public static final String getEaHost() {
        return params.containsKey(KEY_EA_HOST) ? params.get(KEY_EA_HOST) : TWILIO_DEFAULT_EA_HOST;
    }

    private static final void setDevParams(Map<String, String> params) {
        Constants.params = Collections.unmodifiableMap(params);
    }

    static {
        ALLOW_CONTACT_REWRITE_ENABLE = true;
        GLOBAL_LOW_LATENCY_REGION = "gll";
        params = new HashMap<String, String>();
    }

    public static enum Direction {
        INCOMING,
        OUTGOING;

    }

    public static enum SeverityLevel {
        INFO,
        DEBUG,
        WARNING,
        ERROR;

    }
}

