/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import android.support.annotation.NonNull;
import com.twilio.voice.IceServer;
import com.twilio.voice.IceTransportPolicy;
import com.twilio.voice.Preconditions;
import java.util.HashSet;
import java.util.Set;

public class IceOptions {
    private final Set<IceServer> iceServers;
    private final IceTransportPolicy iceTransportPolicy;

    private IceOptions(Builder builder) {
        this.iceServers = builder.iceServers != null ? builder.iceServers : new HashSet();
        this.iceTransportPolicy = builder.iceTransportPolicy;
    }

    @NonNull
    public Set<IceServer> getIceServers() {
        return this.iceServers;
    }

    @NonNull
    public IceTransportPolicy getIceTransportPolicy() {
        return this.iceTransportPolicy;
    }

    IceServer[] getIceServersArray() {
        IceServer[] iceServersArray = new IceServer[]{};
        if (this.iceServers.size() > 0) {
            iceServersArray = this.iceServers.toArray(new IceServer[this.iceServers.size()]);
        }
        return iceServersArray;
    }

    public static class Builder {
        private Set<IceServer> iceServers;
        private IceTransportPolicy iceTransportPolicy = IceTransportPolicy.ALL;

        @NonNull
        public Builder iceServers(@NonNull Set<IceServer> iceServers) {
            Preconditions.checkNotNull(iceServers, "iceServers must not be null");
            this.iceServers = iceServers;
            return this;
        }

        @NonNull
        public Builder iceTransportPolicy(@NonNull IceTransportPolicy iceTransportPolicy) {
            Preconditions.checkNotNull(iceTransportPolicy, "iceTransportPolicy must not be null");
            this.iceTransportPolicy = iceTransportPolicy;
            return this;
        }

        @NonNull
        public IceOptions build() {
            return new IceOptions(this);
        }
    }
}

