/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import android.content.Context;
import android.os.Handler;
import com.twilio.voice.Call;
import com.twilio.voice.Constants;
import com.twilio.voice.EventPayload;
import com.twilio.voice.EventPublisher;
import com.twilio.voice.Logger;
import com.twilio.voice.RTCMonitorCommand;
import com.twilio.voice.RTCStatsSample;
import com.twilio.voice.VoiceException;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONObject;

abstract class InternalCall
implements EventPublisher.EventPublisherListener,
RTCMonitorCommand.Listener {
    private static final Logger logger = Logger.getLogger(InternalCall.class);
    private static final String TEMP_CALL_SID_PREFIX = "TSID";
    String sid;
    String bridgeToken;
    String from;
    String to;
    Handler handler;
    Object callHandle;
    Context context;
    boolean isMuted;
    boolean isOnHold;
    Call.State state;
    boolean disconnectCalled;
    boolean destroyCalled;
    EventPublisher publisher;
    RTCMonitorCommand monitor;
    Constants.Direction direction;
    String callControlHost;
    private JSONArray payload;
    private final UUID uuid = UUID.randomUUID();
    private final String tempCallSid = "TSID" + this.uuid;

    InternalCall() {
    }

    void setSid(String sid) {
        this.sid = sid;
    }

    boolean isValidState() {
        return this.state != Call.State.DISCONNECTED;
    }

    public abstract String getSid();

    public abstract void sendDigits(String var1);

    public abstract Call.State getState();

    public abstract boolean isMuted();

    public abstract void mute(boolean var1);

    public abstract void disconnect();

    @Override
    public void onError(VoiceException voiceException) {
        logger.e("Error publishing data : " + voiceException.getMessage() + ":" + voiceException.getErrorCode());
    }

    @Override
    public void onSample(RTCStatsSample currentSample) {
        currentSample.setCallSid(this.sid);
        if (this.payload == null) {
            this.payload = new JSONArray();
        }
        this.payload.put((Object)currentSample.toJson());
        if (this.payload.length() == 10) {
            if (this.publisher != null) {
                try {
                    this.publisher.publishMetrics("call-quality-stats", "call-metric-event", this.payload);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.payload = new JSONArray();
            } else {
                this.payload = new JSONArray();
            }
        }
    }

    @Override
    public void onWarning(HashMap<String, Object> warningDetails) {
        String callSid = this.getSid();
        EventPayload.WarningName warningName = (EventPayload.WarningName)((Object)warningDetails.get("WarningName"));
        String warningParam = (String)warningDetails.get("WarningParam");
        int threshold = (Integer)warningDetails.get("threshold");
        int sampleValue = warningDetails.get("RecentSampleValue") == null ? 0 : (Integer)warningDetails.get("RecentSampleValue");
        List sampleList = (List)warningDetails.get("RecentSamples");
        String groupType = warningName.toString().compareTo(EventPayload.WarningName.WARN_CONSTANT_AUDIO_IN_LEVEL.toString()) == 0 || warningName.toString().compareTo(EventPayload.WarningName.WARN_CONSTANT_AUDIO_OUT_LEVEL.toString()) == 0 ? "audio-level-warning-raised" : "network-quality-warning-raised";
        EventPayload warningEventPayload = new EventPayload.Builder().callSid(callSid).tempCallSid(this.tempCallSid).direction(this.direction).productName("twilio-voice-android").clientName(null).sampleList(sampleList).sampleValue(sampleValue).qualityParam(warningParam).qualityThreshold(threshold).payLoadType("application/json").build();
        try {
            JSONObject eventPayload = warningEventPayload.getPayload();
            this.publisher.publish(Constants.SeverityLevel.WARNING, groupType, warningName.toString(), eventPayload);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onWarningCleared(EventPayload.WarningName warningName) {
        String callSid = this.getSid();
        String groupType = warningName.toString().compareTo(EventPayload.WarningName.WARN_CONSTANT_AUDIO_IN_LEVEL.toString()) == 0 || warningName.toString().compareTo(EventPayload.WarningName.WARN_CONSTANT_AUDIO_OUT_LEVEL.toString()) == 0 ? "audio-level-warning-cleared" : "network-quality-warning-cleared";
        EventPayload warningClearedEventPayload = new EventPayload.Builder().callSid(callSid).tempCallSid(this.tempCallSid).direction(this.direction).productName("twilio-voice-android").clientName(null).payLoadType("application/json").build();
        try {
            JSONObject eventPayload = warningClearedEventPayload.getPayload();
            this.publisher.publish(Constants.SeverityLevel.INFO, groupType, warningName.toString(), eventPayload);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void publishConnectionEvent(String eventName) {
        logger.d("Publishing event : " + eventName);
        EventPayload eventPayload = new EventPayload.Builder().callSid(this.sid).tempCallSid(this.tempCallSid).direction(this.direction).productName("twilio-voice-android").clientName(null).payLoadType("application/json").build();
        try {
            JSONObject connectionEventPayload = eventPayload.getPayload();
            if (this.publisher != null) {
                this.publisher.publish(Constants.SeverityLevel.INFO, "connection", eventName, connectionEventPayload);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void publishConnectionErrorEvent(String eventName, int errorCode, String errorMessage) {
        logger.d("Publishing event : " + eventName);
        EventPayload eventPayload = new EventPayload.Builder().callSid(this.sid).tempCallSid(this.tempCallSid).direction(this.direction).productName("twilio-voice-android").clientName(null).errorCode(errorCode).errorMessage(errorMessage).payLoadType("application/json").build();
        try {
            JSONObject connectionEventPayload = eventPayload.getPayload();
            if (this.publisher != null) {
                this.publisher.publish(Constants.SeverityLevel.ERROR, "connection", eventName, connectionEventPayload);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void publishIceGatheringEvent(String eventName) {
        logger.d("Publishing event : " + eventName);
        EventPayload eventPayload = new EventPayload.Builder().callSid(this.sid).tempCallSid(this.tempCallSid).direction(this.direction).productName("twilio-voice-android").clientName(null).payLoadType("application/json").build();
        try {
            JSONObject connectionEventPayload = eventPayload.getPayload();
            if (this.publisher != null) {
                this.publisher.publish(Constants.SeverityLevel.DEBUG, "ice-gathering-state", eventName, connectionEventPayload);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void publishIceConnectionEvent(String eventName) {
        logger.d("Publishing event : " + eventName);
        EventPayload eventPayload = new EventPayload.Builder().callSid(this.sid).tempCallSid(this.tempCallSid).direction(this.direction).productName("twilio-voice-android").clientName(null).payLoadType("application/json").build();
        try {
            JSONObject connectionEventPayload = eventPayload.getPayload();
            if (this.publisher != null) {
                Constants.SeverityLevel severityLogLevel = eventName.compareToIgnoreCase("failed") == 0 ? Constants.SeverityLevel.ERROR : Constants.SeverityLevel.DEBUG;
                this.publisher.publish(severityLogLevel, "ice-connection-state", eventName, connectionEventPayload);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

