/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import com.twilio.voice.EventPayload;
import com.twilio.voice.Logger;
import com.twilio.voice.MonitorThresholds;
import com.twilio.voice.RTCStatsProvider;
import com.twilio.voice.RTCStatsSample;
import com.twilio.voice.SessionException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class RTCMonitorCommand
implements Runnable {
    private static final Logger logger = Logger.getLogger(RTCMonitorCommand.class);
    private static final int WARNING_TIMEOUT_IN_MILLISECONDS = 5000;
    private RTCStatsProvider rtcStatsProvider;
    private RTCStatsSample currentSample = null;
    private ArrayList<RTCStatsSample> recentSamples = new ArrayList();
    private Map<EventPayload.WarningName, Date> activeWarnings = new HashMap<EventPayload.WarningName, Date>();
    private int constantAudioInputLevelSampleCounter;
    private int constantAudioOutputLevelSampleCounter;
    private int previousAudioInputLevel;
    private int previousAudioOutputLevel;
    private RTCStatsSample previousSample;
    static int SAMPLE_COUNT_METRICS = 5;
    static final int SAMPLE_COUNT_TO_RAISE_WARNING = 3;
    static MonitorThresholds thresholds = new MonitorThresholds.Builder().jitterThreshold(30).mosScoreThreshhold(3).packetsLostFraction(1).rttThreshold(400).audioConstantInputLevelSampleCounter(10).audioConstantOutputLevelSampleCounter(10).build();
    private List<Listener> listenerList = new ArrayList<Listener>();

    RTCMonitorCommand(RTCStatsProvider stastProvider) {
        this.rtcStatsProvider = stastProvider;
    }

    RTCMonitorCommand(RTCStatsProvider rtcStatsProvider, MonitorThresholds thresholds) {
        if (rtcStatsProvider == null) {
            throw new NullPointerException("RTCStatsProvider must not be null.");
        }
        this.rtcStatsProvider = rtcStatsProvider;
        if (thresholds != null) {
            RTCMonitorCommand.thresholds = thresholds;
        }
    }

    void addListener(Listener listener) {
        this.listenerList.add(listener);
    }

    boolean removeListener(Listener listener) {
        if (this.listenerList != null) {
            return this.listenerList.remove(listener);
        }
        return false;
    }

    RTCStatsSample getSample() {
        return this.currentSample;
    }

    private void monitor(RTCStatsSample currentSample) {
        this.recentSamples.add(currentSample);
        if (this.recentSamples.size() > SAMPLE_COUNT_METRICS) {
            ArrayList<RTCStatsSample> al2 = new ArrayList<RTCStatsSample>(this.recentSamples.subList(1, SAMPLE_COUNT_METRICS + 1));
            this.recentSamples = al2;
        }
        if (thresholds.getMaxDurationConstantAudioInputLevel() > -1) {
            this.checkAudioLevel(currentSample.getAudioInputLevel(), this.previousAudioInputLevel, thresholds.getMaxDurationConstantAudioInputLevel(), EventPayload.WarningName.WARN_CONSTANT_AUDIO_IN_LEVEL);
        }
        if (thresholds.getMaxDurationConstantAudioOutputLevel() > -1) {
            this.checkAudioLevel(currentSample.getAudioOutputLevel(), this.previousAudioOutputLevel, thresholds.getMaxDurationConstantAudioOutputLevel(), EventPayload.WarningName.WARN_CONSTANT_AUDIO_OUT_LEVEL);
        }
        if (thresholds.getMinMosScoreThreshhold() > -1) {
            this.checkAudioQuality("mos", thresholds.getMinMosScoreThreshhold(), ComparisonType.MIN);
        }
        if (thresholds.getMaxJitterThreshold() > -1) {
            this.checkAudioQuality("jitter", thresholds.getMaxJitterThreshold(), ComparisonType.MAX);
        }
        if (thresholds.getMaxRttThreshold() > -1) {
            this.checkAudioQuality("rtt", thresholds.getMaxRttThreshold(), ComparisonType.MAX);
        }
        if (thresholds.getMaxPacketsLostFraction() > -1) {
            this.checkAudioQuality("packetsLostFraction", thresholds.getMaxPacketsLostFraction(), ComparisonType.MAX);
        }
    }

    private void checkAudioLevel(int currentLevel, int previousLevel, int threshold, EventPayload.WarningName warningName) {
        if (warningName == EventPayload.WarningName.WARN_CONSTANT_AUDIO_IN_LEVEL) {
            int n = this.constantAudioInputLevelSampleCounter = currentLevel == previousLevel ? this.constantAudioInputLevelSampleCounter + 1 : 0;
            if (this.constantAudioInputLevelSampleCounter == threshold) {
                this.constantAudioInputLevelSampleCounter = 0;
                this.raiseWarningWithValue(EventPayload.WarningName.WARN_CONSTANT_AUDIO_IN_LEVEL, "audioInputConstantMaxDuration", thresholds.getMaxDurationConstantAudioInputLevel(), currentLevel);
            } else if (this.constantAudioInputLevelSampleCounter == 0) {
                this.clearWarning(EventPayload.WarningName.WARN_CONSTANT_AUDIO_IN_LEVEL);
            }
            this.previousAudioInputLevel = currentLevel;
        } else if (warningName == EventPayload.WarningName.WARN_CONSTANT_AUDIO_OUT_LEVEL) {
            int n = this.constantAudioOutputLevelSampleCounter = currentLevel == previousLevel ? this.constantAudioOutputLevelSampleCounter + 1 : 0;
            if (this.constantAudioOutputLevelSampleCounter == threshold) {
                this.constantAudioOutputLevelSampleCounter = 0;
                this.raiseWarningWithValue(EventPayload.WarningName.WARN_CONSTANT_AUDIO_OUT_LEVEL, "audioOutputConstantMaxDuration", thresholds.getMaxDurationConstantAudioOutputLevel(), currentLevel);
            } else if (this.constantAudioOutputLevelSampleCounter == 0) {
                this.clearWarning(EventPayload.WarningName.WARN_CONSTANT_AUDIO_OUT_LEVEL);
            }
            this.previousAudioOutputLevel = currentLevel;
        }
    }

    private void checkAudioQuality(String name, int threshold, ComparisonType type) {
        int counter = 0;
        if (type == ComparisonType.MAX) {
            counter = RTCMonitorCommand.countHigh(name, threshold, this.recentSamples);
        } else if (type == ComparisonType.MIN) {
            counter = RTCMonitorCommand.countLow(name, threshold, this.recentSamples);
        }
        if (counter >= 3) {
            if (name.compareToIgnoreCase("jitter") == 0) {
                this.raiseWarningWithSamples(EventPayload.WarningName.WARN_HIGH_JITTER, "jitter", thresholds.getMaxJitterThreshold());
            } else if (name.compareToIgnoreCase("rtt") == 0) {
                this.raiseWarningWithSamples(EventPayload.WarningName.WARN_HIGH_RTT, "rtt", thresholds.getMaxRttThreshold());
            } else if (name.compareToIgnoreCase("packetsLostFraction") == 0) {
                this.raiseWarningWithSamples(EventPayload.WarningName.WARN_HIGH_PACKET_LOSS, "packetsLostFraction", thresholds.getMaxPacketsLostFraction());
            } else if (name.compareToIgnoreCase("mos") == 0) {
                this.raiseWarningWithSamples(EventPayload.WarningName.WARN_LOW_MOS, "mos", thresholds.getMinMosScoreThreshhold());
            }
        } else if (counter == 0) {
            if (name.compareToIgnoreCase("jitter") == 0) {
                this.clearWarning(EventPayload.WarningName.WARN_HIGH_JITTER);
            } else if (name.compareToIgnoreCase("rtt") == 0) {
                this.clearWarning(EventPayload.WarningName.WARN_HIGH_RTT);
            } else if (name.compareToIgnoreCase("packetsLostFraction") == 0) {
                this.clearWarning(EventPayload.WarningName.WARN_HIGH_PACKET_LOSS);
            } else if (name.compareToIgnoreCase("mos") == 0) {
                this.clearWarning(EventPayload.WarningName.WARN_LOW_MOS);
            }
        }
    }

    private void setCurrentSample(RTCStatsSample sample) {
        this.currentSample = sample;
        if (this.listenerList != null) {
            for (Listener listener : this.listenerList) {
                if (listener == null) continue;
                listener.onSample(sample);
            }
        }
    }

    private void raiseWarningWithSamples(EventPayload.WarningName nameOfTheWarning, String warningParam, int threshold) {
        if (this.listenerList.size() > 0) {
            this.activeWarnings.put(nameOfTheWarning, new Date());
            HashMap<String, Object> warningDetails = new HashMap<String, Object>();
            warningDetails.put("WarningName", (Object)nameOfTheWarning);
            warningDetails.put("WarningParam", warningParam);
            warningDetails.put("threshold", threshold);
            warningDetails.put("RecentSamples", this.recentSamples);
            for (Listener listener : this.listenerList) {
                if (listener == null) continue;
                listener.onWarning(warningDetails);
            }
        }
    }

    private void raiseWarningWithValue(EventPayload.WarningName nameOfTheWarning, String warningParam, int threshold, int value) {
        if (this.listenerList.size() > 0) {
            Date timeOfWarning = this.activeWarnings.get((Object)nameOfTheWarning);
            if (timeOfWarning != null && new Date().getTime() - timeOfWarning.getTime() < 5000L) {
                return;
            }
            this.activeWarnings.put(nameOfTheWarning, new Date());
            HashMap<String, Object> warningDetails = new HashMap<String, Object>();
            warningDetails.put("WarningName", (Object)nameOfTheWarning);
            warningDetails.put("WarningParam", warningParam);
            warningDetails.put("threshold", threshold);
            warningDetails.put("RecentSampleValue", value);
            for (Listener listener : this.listenerList) {
                if (listener == null) continue;
                listener.onWarning(warningDetails);
            }
        }
    }

    private void clearWarning(EventPayload.WarningName nameOfTheWarning) {
        if ((long)this.listenerList.size() > 0L) {
            Date timeOfWarning = this.activeWarnings.get((Object)nameOfTheWarning);
            if (timeOfWarning == null) {
                return;
            }
            this.activeWarnings.remove((Object)nameOfTheWarning);
            for (Listener listener : this.listenerList) {
                if (listener == null) continue;
                listener.onWarningCleared(nameOfTheWarning);
            }
        }
    }

    static int countLow(String name, int threshold, ArrayList<RTCStatsSample> samples) {
        int lowCount = 0;
        int sampleValue = 0;
        for (RTCStatsSample sample : samples) {
            if (name.compareTo("mos") == 0) {
                sampleValue = (int)sample.getMosScore();
            } else if (name.compareTo("jitter") == 0) {
                sampleValue = sample.getJitter();
            } else if (name.compareTo("rtt") == 0) {
                sampleValue = sample.getRtt();
            } else if (name.compareTo("packetsLostFraction") == 0) {
                sampleValue = (int)sample.getFractionPacketLoss();
            }
            lowCount += sampleValue < threshold ? 1 : 0;
        }
        return lowCount;
    }

    static int countHigh(String name, int threshold, ArrayList<RTCStatsSample> samples) {
        int highCount = 0;
        int sampleValue = 0;
        for (RTCStatsSample sample : samples) {
            if (name.compareTo("mos") == 0) {
                sampleValue = (int)sample.getMosScore();
            } else if (name.compareTo("jitter") == 0) {
                sampleValue = sample.getJitter();
            } else if (name.compareTo("rtt") == 0) {
                sampleValue = sample.getRtt();
            } else if (name.compareTo("packetsLostFraction") == 0) {
                sampleValue = (int)sample.getFractionPacketLoss();
            }
            highCount += sampleValue > threshold ? 1 : 0;
        }
        return highCount;
    }

    @Override
    public void run() {
        try {
            RTCStatsSample sample = new RTCStatsSample(this.rtcStatsProvider.getStats(), this.previousSample);
            if (sample != null) {
                this.setCurrentSample(sample);
                this.monitor(this.currentSample);
                this.previousSample = this.currentSample;
            }
        }
        catch (SessionException e) {
            logger.e("stats collection failed.", e);
        }
    }

    static interface Listener {
        public void onWarning(HashMap<String, Object> var1);

        public void onWarningCleared(EventPayload.WarningName var1);

        public void onSample(RTCStatsSample var1);
    }

    static enum ComparisonType {
        MIN,
        MAX,
        MAXCONSTANTDURATION;

    }
}

