/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import android.annotation.SuppressLint;
import com.twilio.voice.Logger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONObject;

public class RTCStatsSample {
    private static final Logger logger = Logger.getLogger(RTCStatsSample.class);
    double rfactorConstantsr0 = 94.768;
    double rfactorConstantsis = 1.42611;
    double MICRO_TO_MILLI = 0.001;
    private String timeStamp;
    private long timestampMS;
    private double mos;
    long fractionLost;
    long packetsReceived;
    long packetsLost;
    long packetsSent;
    long totalPacketsReceived;
    long totalPacketsSent;
    long totalPacketsLost;
    long totalBytesReceived;
    long totalBytesSent;
    long currentInboundPackets;
    long jitter;
    long rtt;
    int audioInputLevel;
    int audioOutputLevel;
    String callSid;
    private RTCStatsSample previousSample;

    public RTCStatsSample() {
    }

    @SuppressLint(value={"SimpleDateFormat"})
    public RTCStatsSample(RTCStatsSample currentSample, RTCStatsSample previousSample) {
        if (currentSample == null) {
            throw new NullPointerException("payloadType must not be null");
        }
        this.previousSample = previousSample;
        this.populateFields(currentSample);
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        df.setTimeZone(tz);
        Date now = new Date();
        this.timeStamp = df.format(now);
        this.timestampMS = now.getTime();
    }

    public long getPacketsReceived() {
        return this.packetsReceived;
    }

    public long getPacketsLost() {
        return this.packetsLost;
    }

    public long getPacketsSent() {
        return this.packetsSent;
    }

    public long getTotalPacketsReceived() {
        return this.totalPacketsReceived;
    }

    public long getTotalPacketsSent() {
        return this.totalPacketsSent;
    }

    public long getTotalPacketsLost() {
        return this.totalPacketsLost;
    }

    public long getTotalBytesReceived() {
        return this.totalBytesReceived;
    }

    public long getTotalBytesSent() {
        return this.totalBytesSent;
    }

    public int getJitter() {
        return (int)Math.round((double)this.jitter * this.MICRO_TO_MILLI);
    }

    public int getRtt() {
        return (int)Math.round((double)this.rtt * this.MICRO_TO_MILLI);
    }

    public int getAudioInputLevel() {
        return this.audioInputLevel == -1 ? -1 : this.audioInputLevel * 128;
    }

    public int getAudioOutputLevel() {
        return this.audioOutputLevel == -1 ? -1 : this.audioOutputLevel * 128;
    }

    public long getCurrrentInboundPackets() {
        return this.currentInboundPackets;
    }

    public String getCallSid() {
        return this.callSid;
    }

    public void setCallSid(String callSid) {
        this.callSid = callSid;
    }

    private void populateFields(RTCStatsSample currentSample) {
        if (currentSample != null) {
            this.totalPacketsReceived = currentSample.packetsReceived;
            this.packetsReceived = this.previousSample != null ? this.totalPacketsReceived - this.previousSample.totalPacketsReceived : this.totalPacketsReceived;
            this.totalPacketsLost = currentSample.packetsLost;
            this.packetsLost = this.previousSample != null ? this.totalPacketsLost - this.previousSample.totalPacketsLost : this.totalPacketsLost;
            this.totalPacketsSent = currentSample.packetsSent;
            this.packetsSent = this.previousSample != null ? this.totalPacketsSent - this.previousSample.totalPacketsReceived : this.totalPacketsSent;
            this.currentInboundPackets = this.packetsReceived + this.packetsLost;
            this.totalBytesSent = currentSample.totalBytesSent;
            this.totalBytesReceived = currentSample.totalBytesReceived;
            this.jitter = currentSample.jitter;
            this.rtt = currentSample.rtt;
            this.audioInputLevel = currentSample.audioInputLevel;
            this.audioOutputLevel = currentSample.audioOutputLevel;
        }
    }

    public String getTimestamp() {
        return this.timeStamp;
    }

    public JSONObject toJson() {
        try {
            JSONObject eventJSON = new JSONObject();
            eventJSON.put("timestamp", (Object)this.getTimestamp());
            eventJSON.put("timestamp_ms", this.getTimestampMillis());
            eventJSON.put("call_sid", (Object)this.getCallSid());
            eventJSON.put("sdk_version", (Object)"3.0.0-beta2");
            eventJSON.put("packets_received", this.getPacketsReceived());
            eventJSON.put("packets_lost", this.getPacketsLost());
            eventJSON.put("packets_lost_fraction", this.getFractionPacketLoss());
            eventJSON.put("total_packets_sent", this.getTotalPacketsSent());
            eventJSON.put("total_packets_received", this.getTotalPacketsReceived());
            eventJSON.put("total_packets_lost", this.getTotalPacketsLost());
            eventJSON.put("total_bytes_received", this.getTotalBytesReceived());
            eventJSON.put("total_bytes_sent", this.getTotalBytesSent());
            eventJSON.put("jitter", this.getJitter());
            eventJSON.put("rtt", this.getRtt());
            eventJSON.put("audio_level_in", this.getAudioInputLevel());
            eventJSON.put("audio_level_out", this.getAudioOutputLevel());
            eventJSON.put("mos", this.calculateMosParams());
            logger.v(eventJSON.toString());
            return eventJSON;
        }
        catch (Exception e) {
            logger.e(e.toString());
            return null;
        }
    }

    public String toString() {
        return "StatsExtended [timestamp=" + this.timeStamp + ", packetsReceived=" + this.packetsReceived + ", packetsLost=" + this.packetsLost + ", packetsSent=" + this.packetsSent + ", bytesReceived=" + this.totalBytesReceived + ", bytesSent=" + this.totalBytesSent + ", jitter=" + this.jitter + ", rtt=" + this.rtt + ", audioInputLevel=" + this.audioInputLevel + ", audioOutputLevel=" + this.audioOutputLevel + "]";
    }

    private long calculateEffectiveLatency() {
        long effectiveLatency = this.getRtt() + this.getJitter() * 2 + 10;
        return effectiveLatency;
    }

    public long getFractionPacketLoss() {
        this.fractionLost = this.currentInboundPackets > 0L ? (long)((float)this.getPacketsLost() / (float)this.getCurrrentInboundPackets() * 100.0f) : 0L;
        return this.fractionLost;
    }

    private double calculateRFactor(long effectiveLatency, long fractionLost) {
        double rFactor = 0.0;
        if (effectiveLatency < 160L) {
            rFactor = this.rfactorConstantsr0 - (double)(effectiveLatency / 40L);
        } else if (effectiveLatency < 1000L) {
            rFactor = this.rfactorConstantsr0 - (double)((effectiveLatency - 120L) / 10L);
        } else if (effectiveLatency >= 1000L) {
            rFactor = this.rfactorConstantsr0 - (double)(effectiveLatency / 100L);
        }
        double multiplier = 0.01;
        if (fractionLost == -1L) {
            multiplier = 0.0;
            rFactor = 0.0;
        } else if ((double)fractionLost <= rFactor / 2.5) {
            multiplier = 2.5;
        } else if ((double)fractionLost > rFactor / 2.5 && fractionLost < 100L) {
            multiplier = 0.25;
        }
        return rFactor -= (double)fractionLost * multiplier;
    }

    private double calculateMosParams() {
        long effectiveLatency = this.calculateEffectiveLatency();
        long fractionLost = this.getFractionPacketLoss();
        double rFactor = this.calculateRFactor(effectiveLatency, fractionLost);
        return this.calculateMos(rFactor);
    }

    private double calculateMos(double rFactor) {
        double mos = 1.0 + 0.035 * rFactor + 7.0E-6 * rFactor * (rFactor - 60.0) * (100.0 - rFactor);
        double mosMultiplied = Math.round(mos * 100.0);
        this.mos = mosMultiplied / 100.0;
        return mos;
    }

    public long getTimestampMillis() {
        return this.timestampMS;
    }

    public double getMosScore() {
        return this.mos;
    }
}

