/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import com.getkeepsafe.relinker.ReLinker;
import com.twilio.voice.Call;
import com.twilio.voice.CallInvite;
import com.twilio.voice.CancelledCallInvite;
import com.twilio.voice.ConnectOptions;
import com.twilio.voice.LocalAudioTrack;
import com.twilio.voice.LogLevel;
import com.twilio.voice.LogModule;
import com.twilio.voice.Logger;
import com.twilio.voice.MessageListener;
import com.twilio.voice.Preconditions;
import com.twilio.voice.Registrar;
import com.twilio.voice.RegistrationListener;
import com.twilio.voice.UnregistrationListener;
import com.twilio.voice.Utils;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class Voice {
    static AtomicInteger networkChangedCount = new AtomicInteger(0);
    static Map<LogModule, LogLevel> moduleLogLevel = new EnumMap<LogModule, LogLevel>(LogModule.class);
    private static final LogLevel defaultLogLevel;
    static LogLevel level;
    static boolean isLibraryLoaded;
    static final Set<Call> calls;
    static final Set<Call> rejects;

    Voice() {
    }

    public static void register(@NonNull Context context, @NonNull String accessToken, @NonNull RegistrationChannel registrationChannel, @NonNull String registrationToken, @NonNull RegistrationListener listener) {
        Preconditions.checkNotNull(context, "context must not be null");
        Preconditions.checkNotNull(accessToken, "accessToken must not be null");
        Preconditions.checkNotNull(registrationChannel, "registrationChannel must not be null");
        Preconditions.checkNotNull(registrationToken, "registrationToken must not be null");
        Preconditions.checkNotNull(listener, "listener must not be null");
        Registrar registrar = new Registrar(context, accessToken, registrationChannel.toString(), registrationToken);
        registrar.register(listener);
    }

    public static void unregister(@NonNull Context context, @NonNull String accessToken, @NonNull RegistrationChannel registrationChannel, @NonNull String registrationToken, @NonNull UnregistrationListener listener) {
        Preconditions.checkNotNull(context, "context must not be null");
        Preconditions.checkNotNull(accessToken, "accessToken must not be null");
        Preconditions.checkNotNull(registrationChannel, "registrationChannel must not be null");
        Preconditions.checkNotNull(registrationToken, "registrationToken must not be null");
        Preconditions.checkNotNull(listener, "listener must not be null");
        Registrar registrar = new Registrar(context, accessToken, registrationChannel.toString(), registrationToken);
        registrar.unregister(listener);
    }

    @NonNull
    public static Call connect(@NonNull Context context, @NonNull ConnectOptions connectOptions, @NonNull Call.Listener listener) {
        Preconditions.checkNotNull(context, "context must not be null");
        Preconditions.checkNotNull(connectOptions, "connectOptions must not be null");
        Preconditions.checkNotNull(listener, "listener must not be null");
        if (!Utils.isAudioPermissionGranted(context)) {
            throw new SecurityException("Requires the RECORD_AUDIO permission");
        }
        ConnectOptions.Builder builder = new ConnectOptions.Builder(connectOptions.getAccessToken());
        builder.params(connectOptions.getParams());
        if (connectOptions.getIceOptions() != null) {
            builder.iceOptions(connectOptions.getIceOptions());
        }
        if (connectOptions.getRegion() != null) {
            builder.region(connectOptions.getRegion());
        }
        if (connectOptions.getPreferredAudioCodecs() != null) {
            builder.preferAudioCodecs((List)connectOptions.getPreferredAudioCodecs());
        }
        LocalAudioTrack localAudioTrack = LocalAudioTrack.create(context, true);
        builder.audioTracks((List)Collections.singletonList(localAudioTrack));
        builder.eventListener(connectOptions.getEventListener());
        ConnectOptions internalConnectOptions = builder.build();
        Call call = new Call(context, internalConnectOptions.getAccessToken(), listener);
        call.connect(internalConnectOptions);
        return call;
    }

    @NonNull
    public static Call connect(@NonNull Context context, @NonNull String accessToken, @NonNull Call.Listener listener) {
        return Voice.connect(context, new ConnectOptions.Builder(accessToken).build(), listener);
    }

    public static synchronized boolean handleMessage(@NonNull Context context, @NonNull Map<String, String> data, @NonNull MessageListener listener) {
        Preconditions.checkNotNull(context, "context must not be null");
        Preconditions.checkNotNull(data, "data must not be null");
        Preconditions.checkNotNull(listener, "listener must not be null");
        if (CallInvite.isValid(data)) {
            CallInvite callInvite = CallInvite.create(context.getApplicationContext(), data);
            listener.onCallInvite(callInvite);
            return true;
        }
        if (CancelledCallInvite.isValid(data)) {
            CancelledCallInvite cancelledCallInvite = CancelledCallInvite.create(data);
            listener.onCancelledCallInvite(cancelledCallInvite);
            return true;
        }
        return false;
    }

    public static boolean handleMessage(@NonNull Context context, @NonNull Bundle data, @NonNull MessageListener listener) {
        Preconditions.checkNotNull(context, "context must not be null");
        Preconditions.checkNotNull(data, "data must not be null");
        Preconditions.checkNotNull(listener, "listener must not be null");
        HashMap<String, String> dataMap = new HashMap<String, String>();
        for (String key : data.keySet()) {
            dataMap.put(key, String.valueOf(data.get(key)));
        }
        return Voice.handleMessage(context, dataMap, listener);
    }

    @NonNull
    public static String getVersion() {
        return "3.0.0-beta2";
    }

    @NonNull
    public static LogLevel getLogLevel() {
        return level;
    }

    @NonNull
    public static LogLevel getModuleLogLevel(LogModule module) {
        if (moduleLogLevel.containsKey((Object)module)) {
            return moduleLogLevel.get((Object)module);
        }
        return defaultLogLevel;
    }

    public static void setLogLevel(@NonNull LogLevel level) {
        Voice.setSDKLogLevel(level);
        if (isLibraryLoaded) {
            Voice.nativeSetModuleLevel(LogModule.CORE.ordinal(), level.ordinal());
        }
        Voice.level = level;
    }

    public static void setModuleLogLevel(@NonNull LogModule module, @NonNull LogLevel level) {
        if (module == LogModule.PLATFORM) {
            Voice.setSDKLogLevel(level);
        }
        if (isLibraryLoaded) {
            Voice.nativeSetModuleLevel(module.ordinal(), level.ordinal());
        }
        moduleLogLevel.put(module, level);
    }

    private static void setSDKLogLevel(LogLevel level) {
        switch (level) {
            case OFF: {
                Logger.setLogLevel(7);
                break;
            }
            case ERROR: {
                Logger.setLogLevel(6);
                break;
            }
            case WARNING: {
                Logger.setLogLevel(5);
                break;
            }
            case INFO: {
                Logger.setLogLevel(4);
                break;
            }
            case DEBUG: {
                Logger.setLogLevel(3);
                break;
            }
            case TRACE: {
                Logger.setLogLevel(2);
                break;
            }
            case ALL: {
                Logger.setLogLevel(2);
                break;
            }
            default: {
                Logger.setLogLevel(7);
            }
        }
    }

    static void onNetworkChanged() {
        networkChangedCount.incrementAndGet();
    }

    static void loadLibrary(Context context) {
        if (!isLibraryLoaded) {
            ReLinker.loadLibrary((Context)context, (String)"jingle_peerconnection_so");
            isLibraryLoaded = true;
            Voice.setLogLevel(level);
            for (LogModule module : moduleLogLevel.keySet()) {
                Voice.setModuleLogLevel(module, moduleLogLevel.get((Object)module));
            }
        }
    }

    private static native void nativeSetModuleLevel(int var0, int var1);

    static {
        level = defaultLogLevel = LogLevel.ERROR;
        isLibraryLoaded = false;
        calls = new HashSet<Call>();
        rejects = new HashSet<Call>();
    }

    public static enum RegistrationChannel {
        FCM,
        GCM;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

