package com.twilio.voice;

import android.support.annotation.NonNull;

abstract class AudioTrack implements Track {
    private final String name;
    private boolean isEnabled;

    AudioTrack(boolean isEnabled, @NonNull String name) {
        this.isEnabled = isEnabled;
        this.name = name;
    }

    /**
     * Check if this audio track is enabled.
     *
     * @return true if track is enabled.
     */
    @Override
    public boolean isEnabled() {
        return isEnabled;
    }

    /**
     * Returns the audio track name. A pseudo random string is returned if no track name was
     * specified.
     */
    @Override
    public String getName() {
        return name;
    }

    void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }
}
