package com.twilio.voice;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import java.util.Map;

/**
 * Represents an incoming call cancellation message from Twilio.
 */
public class CancelledCallInvite implements Parcelable {
    private final String from;
    private final String to;
    private final String callSid;

    /**
     * Returns the caller information.
     */
    @Nullable public String getFrom() {
        return from;
    }

    /**
     * Returns the callee information.
     */
    @NonNull public String getTo() {
        return to;
    }

    /**
     * Returns the CallSid.
     */
    @NonNull public String getCallSid() {
        return callSid;
    }

    static CancelledCallInvite create(Map<String, String> data) {
        return new CancelledCallInvite(data);
    }

    private CancelledCallInvite(Map<String, String> data) {
        from = data.get(VoiceConstants.FROM);
        to = data.get(VoiceConstants.TO);
        callSid = data.get(VoiceConstants.CALL_SID);
    }

    private CancelledCallInvite(Parcel in) {
        String[] data = new String[3];
        in.readStringArray(data);
        from = data[0];
        to = data[1];
        callSid = data[2];
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeStringArray(new String[]{from, to, callSid});
    }

    public static final Parcelable.Creator CREATOR = new Parcelable.Creator() {
        public CancelledCallInvite createFromParcel(Parcel in) {
            return new CancelledCallInvite(in);
        }

        public CancelledCallInvite[] newArray(int size) {
            return new CancelledCallInvite[size];
        }
    };

    static boolean isValid(Map<String, String> data) {
        final String messageType = data.get(VoiceConstants.VOICE_TWI_MESSAGE_TYPE);
        final String callSid = data.get(VoiceConstants.CALL_SID);
        final String to = data.get(VoiceConstants.TO);
        return messageType != null &&
                messageType.equals(VoiceConstants.MESSAGE_TYPE_CANCEL) &&
                callSid != null &&
                to != null;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof CancelledCallInvite) {
            CancelledCallInvite cancelledCallInvite = (CancelledCallInvite)o;
            // Validate equality based on the publicly visible state
            return getFrom().equals(cancelledCallInvite.getFrom()) &&
                    getTo().equals(cancelledCallInvite.getTo()) &&
                    getCallSid().equals(cancelledCallInvite.getCallSid());
        } else {
            return false;
        }
    }
}
