package com.twilio.voice;

import android.os.Build;

import com.twilio.voice.Constants.SeverityLevel;

import org.json.JSONException;
import org.json.JSONObject;


class EventMetadata {
    String timeStamp;
    String productName;
    SeverityLevel level;
    String groupName;
    String eventName;
    String callSid;
    String payloadType;
    long timestampMS;
    boolean isPrivate = false;

    String getTimeStamp() {
        return this.timeStamp;
    }

    Object getPayloadType() {
        return this.payloadType;
    }

    String getProductName() {
        return this.productName;
    }

    SeverityLevel getLevel() {
        return this.level;
    }

    boolean isPrivate() {
        return this.isPrivate;
    }

    String getGroupName() {
        return this.groupName;
    }

    String getEventName() {
        return this.eventName;
    }

    String getCallSid() {
        return this.callSid;
    }

    long getTimestampMillis() {
        return this.timestampMS;
    }

    JSONObject jsonEnvelopePreparation(String productName, String eventName, String groupName) throws JSONException {
        JSONObject envelope = new JSONObject();
        envelope.put(EventKeys.EVENT_NAME, this.eventName);
        envelope.put(EventKeys.EVENT_GROUP, this.groupName);
        envelope.put(EventKeys.TIMESTAMP, this.timeStamp);
        envelope.put(EventKeys.LEVEL_TAG, this.level);
        envelope.put(EventKeys.PRIVATE, this.isPrivate);
        envelope.put(EventKeys.PAYLOAD_TYPE, this.payloadType);
        envelope.put(EventKeys.PUBLISHER, this.productName);
        return envelope;
    }

    JSONObject jsonPublisherMetadataPreparation() throws JSONException {
        JSONObject publisherMetadata = new JSONObject();
        publisherMetadata.put(PublisherMetadata.CLIENT_ADDRESS, Utils.getIPAddress(false));
        publisherMetadata.put(PublisherMetadata.OS_NAME, Constants.PLATFORM_ANDROID);
        publisherMetadata.put(PublisherMetadata.OS_VERSION, Build.VERSION.RELEASE);
        publisherMetadata.put(PublisherMetadata.DEVICE_MODEL, Build.MODEL);
        publisherMetadata.put(PublisherMetadata.DEVICE_VENDOR, Build.MANUFACTURER);
        publisherMetadata.put(PublisherMetadata.DEVICE_TYPE, Build.MODEL);
        publisherMetadata.put(PublisherMetadata.CPU_ARCHITECTURE, Build.CPU_ABI);

        return publisherMetadata;
    }
}
