package com.twilio.voice;

import android.support.annotation.NonNull;

/**
 * The MessageListener interface defines a set of callbacks for events related to push notifications
 * for incoming calls.
 */
public interface MessageListener {
    /**
     * Notifies the listener that an incoming call invite has been received.
     */
    void onCallInvite(@NonNull CallInvite callInvite);

    /**
     * Notifies the listener that an incoming call invite was cancelled.
     */
    void onCancelledCallInvite(@NonNull CancelledCallInvite cancelledCallInvite);
}
