package com.twilio.voice;

import android.annotation.SuppressLint;

import com.twilio.voice.Constants.SeverityLevel;

import org.json.JSONArray;
import org.json.JSONObject;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

class MetricEvent extends EventMetadata {

    private JSONArray payload;

    private MetricEvent(Builder builder) {
        this.productName = builder.productName;
        this.level = builder.level;
        this.groupName = builder.groupName;
        this.eventName = builder.eventName;
        this.callSid = builder.callSid;
        this.payloadType = builder.payloadType;
        this.payload = builder.payload;
    }

    @SuppressLint("SimpleDateFormat")
    public JSONObject toJSONObject() throws Exception {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        DateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        df.setTimeZone(tz);
        this.timeStamp = df.format(new Date());

        JSONObject metricEventJsonObject = this.jsonEnvelopePreparation(this.productName, EventType.CALL_METRIC_EVENT, EventGroupType.CALL_QUALITY_STATS_GROUP);
        JSONObject publisherMetadata = this.jsonPublisherMetadataPreparation();
        metricEventJsonObject.put(PublisherMetadata.PUBLISHER_META_DATA, publisherMetadata);
        metricEventJsonObject.put(EventKeys.PAYLOAD, this.payload);

        return metricEventJsonObject;
    }

    public void addStatsToPayload(JSONObject samplePayload) {
        if (this.payload == null) {
            this.payload = new JSONArray();
        }
        this.payload.put(samplePayload);
    }

    public JSONArray getPayload() {
        return this.payload;
    }

    public void setPayload(JSONArray jsonArray) {
        this.payload = jsonArray;
    }

    static class Builder {

        private String productName;
        private SeverityLevel level;
        private String groupName;
        private String eventName;
        private String callSid;
        private String payloadType;
        private JSONArray payload;

        Builder() {
        }

        Builder productName(String productName) {
            this.productName = productName;
            return this;
        }

        Builder level(SeverityLevel level) {
            this.level = level;
            return this;
        }

        Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        Builder eventName(String eventName) {
            this.eventName = eventName;
            return this;
        }

        Builder payLoadType(String payloadType) {
            this.payloadType = payloadType;
            return this;
        }

        Builder payLoad(JSONArray metrics) {
            this.payload = metrics;
            return this;
        }

        MetricEvent build() {

            if (this.productName == null) {
                throw new NullPointerException("productName must not be null");
            }

            if (this.level == null) {
                throw new NullPointerException("level must not be null");
            }

            if (this.groupName == null) {
                throw new NullPointerException("groupName must not be null");
            }

            if (this.eventName == null) {
                throw new NullPointerException("eventName must not be null");
            }

            if (this.payloadType == null) {
                throw new NullPointerException("payloadType must not be null");
            }

            return new MetricEvent(this);
        }
    }
}
