package com.twilio.voice;

import org.json.JSONObject;

class RTCStatsSample {
    private static final Logger logger = Logger.getLogger(RTCStatsSample.class);

    String timeStamp;
    long timestampMS;
    double mos;
    int fractionLost;
    long packetsReceived;
    long packetsLost;
    long packetsSent;
    long totalPacketsReceived;
    long totalPacketsSent;
    long totalPacketsLost;
    long totalBytesReceived;
    long totalBytesSent;
    int jitter;
    int rtt;
    int audioInputLevel;
    int audioOutputLevel;
    String callSid;
    String codec;
    Constants.Direction direction;

    public RTCStatsSample() {
        super();
    }

    public long getPacketsReceived() {
        return packetsReceived;
    }

    public long getPacketsLost() {
        return packetsLost;
    }

    public long getPacketsSent() {
        return packetsSent;
    }

    public long getTotalPacketsReceived() {
        return totalPacketsReceived;
    }

    public long getTotalPacketsSent() {
        return totalPacketsSent;
    }

    public long getTotalPacketsLost() {
        return totalPacketsLost;
    }

    public long getTotalBytesReceived() {
        return totalBytesReceived;
    }

    public long getTotalBytesSent() {
        return totalBytesSent;
    }

    public int getJitter() {
        return jitter;
    }

    public int getRtt() {
        return rtt;
    }

    public int getAudioInputLevel() {
        return audioInputLevel == -1 ? -1 : audioInputLevel * 128;
    }

    public int getAudioOutputLevel() {
        return audioOutputLevel == -1 ? -1 : audioOutputLevel * 128;
    }

    public String getCodec() {
        return codec;
    }

    public double getFractionLost() {
        return fractionLost;
    }

    public String getCallSid() {
        return this.callSid;
    }

    public double getMos() {
        return this.mos;
    }

    public void setCallSid(String callSid) {
        this.callSid = callSid;
    }
    public void setDirection(Constants.Direction direction) {
        this.direction = direction;
    }

    public String getTimestamp() {
        return timeStamp;
    }

    public JSONObject toJson() {
        try {
            JSONObject eventJSON = new JSONObject();

            eventJSON.put(EventKeys.TIMESTAMP, getTimestamp());
            eventJSON.put(EventKeys.TIMESTAMP_MS, getTimestampMillis());
            eventJSON.put(EventKeys.CALL_SID, getCallSid());
            eventJSON.put(EventKeys.SDK_VERSION_KEY, BuildConfig.VERSION_NAME);

            eventJSON.put(MetricEventConstants.MetricEventKeys.PACKETS_RECEIVED, getPacketsReceived());
            eventJSON.put(MetricEventConstants.MetricEventKeys.TOTAL_PACKETS_LOST, getTotalPacketsLost());
            eventJSON.put(MetricEventConstants.MetricEventKeys.PACKETS_LOST_FRACTION, getFractionLost());
            eventJSON.put(MetricEventConstants.MetricEventKeys.PACKETS_LOST, getPacketsLost());
            eventJSON.put(MetricEventConstants.MetricEventKeys.TOTAL_PACKETS_SENT, getTotalPacketsSent());
            eventJSON.put(MetricEventConstants.MetricEventKeys.TOTAL_PACKETS_RECEIVED, getTotalPacketsReceived());
            eventJSON.put(MetricEventConstants.MetricEventKeys.TOTAL_BYTES_RECEIVED, getTotalBytesReceived());
            eventJSON.put(MetricEventConstants.MetricEventKeys.TOTAL_BYTES_SENT, getTotalBytesSent());
            eventJSON.put(MetricEventConstants.MetricEventKeys.JITTER, getJitter());
            eventJSON.put(MetricEventConstants.MetricEventKeys.RTT, getRtt());
            eventJSON.put(MetricEventConstants.MetricEventKeys.AUDIO_INPUT_LEVEL, getAudioInputLevel());
            eventJSON.put(MetricEventConstants.MetricEventKeys.AUDIO_OUTPUT_LEVEL, getAudioOutputLevel());
            eventJSON.put(MetricEventConstants.MetricEventKeys.MOS, getMos());
            eventJSON.put(MetricEventConstants.MetricEventKeys.AUDIO_CODEC, getCodec());
            eventJSON.put(EventKeys.DIRECTION_KEY, this.direction);

            logger.v(eventJSON.toString());
            return eventJSON;
        } catch (Exception e) {
            logger.e(e.toString());
            return null;
        }
    }

    @Override
    public String toString() {
        return "StatsExtended [timestamp=" + timeStamp + ", packetsReceived=" + packetsReceived + ", packetsLost="
                + packetsLost + ", packetsSent=" + packetsSent + ", bytesReceived=" + totalBytesReceived
                + ", bytesSent=" + totalBytesSent + ", jitter=" + jitter + ", rtt=" + rtt + ", audioInputLevel="
                + audioInputLevel + ", audioOutputLevel=" + audioOutputLevel + "]";
    }

    public long getTimestampMillis() {
        return timestampMS;
    }

    public double getMosScore() {
        return this.mos;
    }
}
