package com.twilio.voice;

import android.util.Log;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class Registration {
    private static final String VERSION = "3";

    private final String channelType;
    private final MessageTypes messageTypes;
    private final RegistrationData data;
    private final String version;

    public Registration(String channelType, String deviceToken) {
        this.channelType = channelType;
        this.messageTypes = new MessageTypes();
        this.version = VERSION;
        this.data = new RegistrationData(deviceToken);
    }

    private class MessageTypes {
        private final String CALL_TYPE = "twilio.voice.call";
        private final String CANCEL_TYPE = "twilio.voice.cancel";

        public JSONArray toJson() {
            try {
                JSONArray jsonArray = new JSONArray();
                jsonArray.put(0, CALL_TYPE);
                jsonArray.put(1, CANCEL_TYPE);
                return jsonArray;
            } catch (JSONException e) {
                Log.e(getClass().getSimpleName(), e.toString());
                return null;
            }
        }
    }
    private class RegistrationData {
        String registrationId;

        public RegistrationData(String registrationId) {
            this.registrationId = registrationId;
        }

        public JSONObject toJson() {
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("registration_id", registrationId);
                return jsonObject;
            } catch (Exception e) {
                Log.e(getClass().getSimpleName(), e.toString());
                return null;
            }
        }
    }

    public JSONObject toJson() {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("channel_type", channelType);
            jsonObject.put("message_types", messageTypes.toJson());
            jsonObject.put("data", data.toJson());
            jsonObject.put("version", version);
            return jsonObject;
        } catch (Exception e) {
            Log.e(getClass().getSimpleName(), e.toString());
            return null;
        }
    }

}
