package com.twilio.voice;

/**
 * Exceptions related to registering for push notifications.
 */
public class RegistrationException extends VoiceException {
    /**
     *
     * @deprecated Use {@link RegistrationException#EXCEPTION_REGISTRATION_ERROR}
     */
    @Deprecated
    public static final int REGISTRATION_ERROR_CODE = 31301;
    public static final int EXCEPTION_REGISTRATION_ERROR = 31301;
    public static final int EXCEPTION_CONFLICT = 31409;
    public static final int EXCEPTION_UPGRADE_REQUIRED = 31426;
    public static final int EXCEPTION_TOO_MANY_REQUEST = 31429;

    static final RegistrationException ConflictException = new RegistrationException(EXCEPTION_CONFLICT, "Conflict", "The request could not be processed because of a conflict in the current state of the resource. Another request may be in progress.");
    static final RegistrationException TooManyRequestException = new RegistrationException(EXCEPTION_TOO_MANY_REQUEST, "Too Many Requests", "Too many requests were sent in a given amount of time.");
    static final RegistrationException UpgradeRequiredException = new RegistrationException(EXCEPTION_UPGRADE_REQUIRED, "Upgrade Required", "The client should switch to a different protocol.");

    // TODO CLIENT-6016 : make constructor package scope
    public RegistrationException(int errorCode, String errorMessage, String explanation) {
        super(errorCode, errorMessage, explanation);
    }
}
