package com.twilio.voice;

import android.support.annotation.NonNull;

/**
 * RegistrationListener interface defines a set of callbacks for events related to
 * {@link Voice}'s register request.
 */
public interface RegistrationListener {

    /**
     * Reports a successful GCM or FCM token registration.
     */
    void onRegistered(@NonNull String accessToken, @NonNull String fcmToken);

    /**
     * Reports an error related to GCM or FCM token registration.
     *
     * @param registrationException Exception containing information about the cause of the failure.
     */
    void onError(@NonNull RegistrationException registrationException,
                 @NonNull String accessToken,
                 @NonNull String fcmToken);
}
