package com.twilio.voice;

/**
 * UnregistrationListener interface defines a set of callbacks for events related to
 * {@link Voice}'s unregister request.
 */
public interface UnregistrationListener {
    /**
     * Reports a successful GCM or FCM token unregistration.
     */
    void onUnregistered(String accessToken, String fcmToken);

    /**
     * Reports an error related to GCM or FCM token unregistration.
     */
    void onError(RegistrationException registrationException, String accessToken, String fcmToken);
}
