package com.twilio.voice;

import android.annotation.SuppressLint;
import android.util.Pair;

import com.twilio.voice.Constants.Direction;

import org.json.JSONObject;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

class EventPayload {
    boolean isPrivate = false;
    private String timeStamp;
    private String productName;
    private String callSid;
    private String messageSid;
    private String payloadType;
    private long timestampMS;
    private JSONObject payload;
    private String clientName;
    private Direction direction;
    private String value;
    private String values;
    private Pair<String, Class> qualityThresholdValuePair;
    private String tempCallSid;
    private int qualityScore;
    private String issueName;
    private Long errorCode;
    private String errorMessage;
    private String requestId;
    private String selectedRegion;
    private String gateway;
    private String region;
    private String codecParams;
    private String selectedCodec;
    private String transportId;
    private Boolean isRemote;
    private String ip;
    private Long port;
    private String protocol;
    private String candidateType;
    private Long priority;
    private String url;
    private Boolean deleted;
    private Long networkCost;
    private Long networkId;
    private Long relatedPort;
    private String level;
    private String relatedAddress;
    private String networkType;
    private String name;
    private String tcpType;
    private JSONObject localCandidate;
    private JSONObject remoteCandidate;
    private Long lastDataReceivedMs;
    private String reason;

    private EventPayload(Builder builder) {
        this.productName = builder.productName;
        this.payload = builder.payload;
        this.payloadType = builder.payloadType;
        this.timeStamp = builder.timeStamp;
        this.timestampMS = builder.timestampMS;
        this.clientName = builder.clientName;
        this.direction = builder.direction;
        this.callSid = builder.callSid;
        this.messageSid = builder.messageSid;
        this.tempCallSid = builder.tempCallSid;
        this.qualityScore = builder.qualityScore;
        this.issueName = builder.issue;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
        this.requestId = builder.requestId;
        this.selectedRegion = builder.selectedRegion;
        this.gateway = builder.gateway;
        this.region = builder.region;
        this.codecParams = builder.codecParams;
        this.selectedCodec = builder.selectedCodec;
        this.transportId = builder.transportId;
        this.isRemote = builder.isRemote;
        this.ip = builder.ip;
        this.port = builder.port;
        this.protocol = builder.protocol;
        this.candidateType = builder.candidateType;
        this.priority = builder.priority;
        this.url = builder.url;
        this.deleted = builder.deleted;
        this.networkCost = builder.networkCost;
        this.values = builder.values;
        this.value = builder.value;
        this.qualityThresholdValuePair = builder.qualityThresholdValuePair;
        this.networkId = builder.networkId;
        this.relatedPort = builder.relatedPort;
        this.level = builder.level;
        this.relatedAddress = builder.relatedAddress;
        this.networkType = builder.networkType;
        this.name = builder.name;
        this.tcpType = builder.tcpType;
        this.localCandidate = builder.localCandidate;
        this.remoteCandidate = builder.remoteCandidate;
        this.reason = builder.reason;
        this.lastDataReceivedMs = builder.lastDataReceivedMs;
    }

    String getTimeStamp() {
        return this.timeStamp;
    }

    Object getPayloadType() {
        return this.payloadType;
    }

    String getProductName() {
        return this.productName;
    }

    boolean isPrivate() {
        return this.isPrivate;
    }

    String getCallSid() {
        return this.callSid;
    }

    long getTimestampMillis() {
        return this.timestampMS;
    }

    JSONObject getPayload() throws Exception {
        jsonPayloadPreparation();
        return this.payload;
    }

    String getClientName() {
        return this.clientName;
    }

    Direction getDirection() {
        return this.direction;
    }

    String getTempCallSid() {
        return this.tempCallSid;
    }

    int getQualityScore() {
        return this.qualityScore;
    }

    String getIssueName() {
        return this.issueName;
    }


    JSONObject jsonPayloadPreparation()
            throws Exception {
        JSONObject payload = new JSONObject();
        payload.put(EventKeys.TIMESTAMP_MS, this.timestampMS);
        payload.put(EventKeys.CLIENT_NAME, this.clientName);
        payload.put(EventKeys.TEMP_CALL_SID, this.tempCallSid);
        payload.put(EventKeys.CALL_SID, this.callSid);
        payload.put(EventKeys.MESSAGE_SID, this.messageSid);
        payload.put(EventKeys.SDK_VERSION_KEY, Voice.getVersion());
        payload.put(EventKeys.PLATFORM, Constants.PLATFORM_ANDROID);
        payload.put(EventKeys.DIRECTION_KEY, this.direction);
        payload.put(EventKeys.SELECTED_REGION_KEY, this.selectedRegion);
        payload.put(EventKeys.GATEWAY, this.gateway);
        payload.put(EventKeys.REGION, this.region);
        payload.put(EventKeys.CODEC_PARAMS, this.codecParams);
        payload.put(EventKeys.SELECTED_CODEC, this.selectedCodec);
        payload.put(EventKeys.TRANSPORT_ID, this.transportId);
        payload.put(EventKeys.IS_REMOTE, this.isRemote);
        payload.put(EventKeys.IP, this.ip);
        payload.put(EventKeys.PORT, this.port);
        payload.put(EventKeys.PROTOCOL, this.protocol);
        payload.put(EventKeys.CANDIDATE_TYPE, this.candidateType);
        payload.put(EventKeys.PRIORITY, this.priority);
        payload.put(EventKeys.URL, this.url);
        payload.put(EventKeys.DELETED, this.deleted);
        payload.put(EventKeys.NETWORK_COST, this.networkCost);
        payload.put(EventKeys.NETWORK_ID, this.networkId);
        payload.put(EventKeys.RELATED_PORT, this.relatedPort);
        payload.put(EventKeys.LEVEL, this.level);
        payload.put(EventKeys.RELATED_ADDRESS, this.relatedAddress);
        payload.put(EventKeys.NETWORK_TYPE, this.networkType);
        payload.put(EventKeys.NAME, this.name);
        payload.put(EventKeys.TCP_TYPE, this.tcpType);
        payload.put(EventKeys.LOCAL_CANDIDATE, this.localCandidate);
        payload.put(EventKeys.REMOTE_CANDIDATE, this.remoteCandidate);
        payload.put(EventKeys.REASON, this.reason);
        payload.put(EventKeys.LAST_DATA_RECEIVED_MS, this.lastDataReceivedMs);

        if (this.errorCode != null && this.errorCode.compareTo(Long.valueOf(0)) > 0) {
            payload.put(EventKeys.ERROR_CODE, this.errorCode);
            payload.put(EventKeys.ERROR_MESSAGE, this.errorMessage);
        }
        if (this.requestId != null) {
            payload.put(EventKeys.REQUEST_ID_KEY, this.requestId);
        }

        JSONObject data = new JSONObject();

        if (this.values != null) {
            data.put(EventKeys.THRESHOLD_KEY, fromStringThreshold(this.qualityThresholdValuePair));
            data.put(EventKeys.VALUES_KEY, values);
        } else if (this.value != null) {
            data.put(EventKeys.THRESHOLD_KEY, fromStringThreshold(this.qualityThresholdValuePair));
            data.put(EventKeys.VALUE_KEY, this.value);
        } else {
            if (this.qualityScore > 0) {
                // Feedback event score
                payload.put(EventKeys.QUALITY_SCORE, this.qualityScore);
            }
            if (this.issueName != null && !this.issueName.equals(Call.Issue.NOT_REPORTED.toString())) {
                // Feedback event issue name
                payload.put(EventKeys.ISSUE_NAME, this.issueName);
            }
            // Connection Event and more that don't include sample value(s).
            data = null;
        }

        payload.put(EventKeys.DATA, data);
        this.payload = payload;
        return this.payload;
    }

    static class Builder {
        private String productName;
        private JSONObject payload;
        private String payloadType;
        private long timestampMS;
        private String timeStamp;
        private String callSid;
        private String messageSid;
        private String clientName;
        private Direction direction;
        private String values;
        private String value;
        private String qualityParam;
        private Pair<String, Class> qualityThresholdValuePair;
        private String tempCallSid;
        private int qualityScore;
        private String issue;
        private Long errorCode;
        private String errorMessage;
        private String requestId;
        private String selectedRegion;
        private String gateway;
        private String region;
        private String codecParams;
        private String selectedCodec;
        private String transportId;
        private Boolean isRemote;
        private String ip;
        private Long port;
        private String protocol;
        private String candidateType;
        private Long priority;
        private String url;
        private Boolean deleted;
        private Long networkCost;
        private Long networkId;
        private Long relatedPort;
        private String level;
        private String relatedAddress;
        private String networkType;
        private String name;
        private String tcpType;
        private JSONObject localCandidate;
        private JSONObject remoteCandidate;
        private Long lastDataReceivedMs;
        private String reason;

        @SuppressLint("SimpleDateFormat")
        Builder() {
            TimeZone tz = TimeZone.getTimeZone("UTC");
            DateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            df.setTimeZone(tz);
            Date now = new Date();
            this.timeStamp = df.format(now);
            this.timestampMS = now.getTime();
        }

        Builder productName(String productName) {
            this.productName = productName;
            return this;
        }

        Builder payLoadType(String payloadType) {
            this.payloadType = payloadType;
            return this;
        }

        Builder callSid(String callSid) {
            this.callSid = callSid;
            return this;
        }

        Builder messageSid(String messageSid) {
            this.messageSid = messageSid;
            return this;
        }

        Builder clientName(String clientName) {
            this.clientName = clientName;
            return this;
        }

        Builder direction(Direction direction) {
            this.direction = direction;
            return this;
        }

        Builder value(String value) {
            this.value = value;
            return this;
        }

        Builder values(String values) {
            this.values = values;
            return this;
        }

        Builder qualityThresholdValuePair(Pair<String, Class> qualityThresholdValuePair) {
            this.qualityThresholdValuePair = qualityThresholdValuePair;
            return this;
        }

        Builder tempCallSid(String tempCallSid) {
            this.tempCallSid = tempCallSid;
            return this;
        }

        Builder score(Call.Score score) {
            if (score != null) {
                this.qualityScore = score.getValue();
            }
            return this;
        }

        Builder issue(Call.Issue issue) {
            if (issue != null) {
                this.issue = issue.toString();
            }
            return this;
        }

        Builder errorCode(Long errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        Builder selectedRegion(String selectedRegion) {
            this.selectedRegion = selectedRegion;
            return this;
        }

        Builder gateway(String gateway) {
            this.gateway = gateway;
            return this;
        }

        Builder region(String region) {
            this.region = region;
            return this;
        }

        Builder codecParams(String codecParams) {
            this.codecParams = codecParams;
            return this;
        }

        Builder selectedCodec(String selectedCodec) {
            this.selectedCodec = selectedCodec;
            return this;
        }

        Builder transportId(String transportId) {
            this.transportId = transportId;
            return this;
        }

        Builder isRemote(Boolean isRemote) {
            this.isRemote = isRemote;
            return this;
        }

        Builder ip(String ip) {
            this.ip = ip;
            return this;
        }

        Builder port(Long port) {
            this.port = port;
            return this;
        }

        Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        Builder candidateType(String candidateType) {
            this.candidateType = candidateType;
            return this;
        }

        Builder priority(Long priority) {
            this.priority = priority;
            return this;
        }

        Builder url(String url) {
            this.url = url;
            return this;
        }

        Builder deleted(Boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        Builder networkCost(Long networkCost) {
            this.networkCost = networkCost;
            return this;
        }

        Builder networkId(Long networkId) {
            this.networkId = networkId;
            return this;
        }

        Builder relatedPort(Long relatedPort) {
            this.relatedPort = relatedPort;
            return this;
        }

        Builder level(String level) {
            this.level = level;
            return this;
        }

        Builder relatedAddress(String relatedAddress) {
            this.relatedAddress = relatedAddress;
            return this;
        }

        Builder networkType(String networkType) {
            this.networkType = networkType;
            return this;
        }

        Builder name(String name) {
            this.name = name;
            return this;
        }

        Builder tcpType(String tcpType) {
            this.tcpType = tcpType;
            return this;
        }

        Builder localCandidate(JSONObject localCandidate) {
            this.localCandidate = localCandidate;
            return this;
        }

        Builder remoteCandidate(JSONObject remoteCandidate) {
            this.remoteCandidate = remoteCandidate;
            return this;
        }

        Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        Builder lastDataReceivedMs(Long lastDataReceivedMs) {
            this.lastDataReceivedMs = lastDataReceivedMs;
            return this;
        }

        EventPayload build() {

            if (this.productName == null) {
                throw new NullPointerException("productName must not be null");
            }

            if (this.payloadType == null) {
                throw new NullPointerException("payloadType must not be null");
            }

            return new EventPayload(this);
        }
    }

    static Object fromStringThreshold(Pair<String, Class> stringValuePair) {
        Object object;
        Class reifiedType;

        if (stringValuePair.second.equals(Float.class)) {
            object = Float.parseFloat(stringValuePair.first);
            reifiedType = Float.class;
            return reifiedType.cast(object);
        } else if (stringValuePair.second.equals(Long.class)) {
            object = Long.parseLong(stringValuePair.first);
            reifiedType = Long.class;
            return reifiedType.cast(object);
        } else {
            object = stringValuePair.first;
            reifiedType = String.class;
            return reifiedType.cast(object);
        }
    }
}
