package com.twilio.voice;

public class RemoteAudioTrackStats extends RemoteTrackStats {
    /** Audio output level */
    public final int audioLevel;

    /** Packet jitter measured in milliseconds */
    public final int jitter;

    /**
     * The Mean Opinion Score (MOS). This is a measure of the call audio quality.
     *
     * <p>
     * The Mean Opinion Score (MOS) represents the call audio quality where a score of 5 represents
     * the best audio possible, for example, real world face to face speech, and 1 represents audio
     * quality that is unintelligible. Typically, a score of 3.5 or below for a few seconds becomes
     * annoying to the user. The score is calculated using [Vincenty's formulae](https://en.wikipedia.org/wiki/Vincenty%27s_formulae) once
     * per second and uses `jitter`, `rtt`, and `packet loss` values to perform the calculation.
     * The following table describes how MOS relates to quality:
     * </p>
     *
     * <table border="1">
     * <caption>mos</caption>
     * <tr>
     * <td>MOS Range</td><td>Perceived Quality</td>
     * </tr>
     * <tr>
     * <td>= 4.2</td><td>Excellent</td>
     * </tr>
     * <tr>
     * <td>4.1 - 4.2</td><td>Great</td>
     * </tr>
     * <tr>
     * <td>3.7 - 4.0</td><td>Good</td>
     * </tr>
     * <tr>
     * <td>3.1 - 3.6</td><td>Almost unintelligible</td>
     * </tr>
     * <tr>
     * <td>3.1</td><td>Degraded/Unacceptable</td>
     * </tr>
     * </table>
     */
    public final float mos;

    RemoteAudioTrackStats(
            String trackId,
            int packetsLost,
            String codec,
            String ssrc,
            double timestamp,
            long bytesReceived,
            int packetsReceived,
            int audioLevel,
            int jitter,
            float mos) {
        super(trackId, packetsLost, codec, ssrc, timestamp, bytesReceived, packetsReceived);
        this.audioLevel = audioLevel;
        this.jitter = jitter;
        this.mos = mos;
    }
}

