package com.twilio.voice;

import java.security.MessageDigest;
import java.security.SecureRandom;

/**
 * SidUtil provides utility functions for creating twilio sids.
 */
class SidUtil {

    private static final SecureRandom srand;

    static {

        srand = new SecureRandom();
        // force PRNG to seed itself
        final byte[] bytes = new byte[64];
        srand.nextBytes(bytes);
    }

    private static final String md5(final String toEncrypt) {
        try {
            final MessageDigest digest = MessageDigest.getInstance("md5");
            digest.update(toEncrypt.getBytes());
            final byte[] bytes = digest.digest();
            final StringBuilder sb = new StringBuilder();
            for (int i = 0; i < bytes.length; i++) {
                sb.append(String.format("%02X", bytes[i]));
            }
            return sb.toString().toLowerCase();
        } catch (Exception exc) {
            return "";
        }
    }

    /**
     * generate a unique hash.
     *
     * @return a random md5hash
     */
    private static String generateGuidHash(String randomString) {
        final byte[] bytes = new byte[64];
        srand.nextBytes(bytes);
        final String random = new String(bytes);

        return md5(randomString + random + System.currentTimeMillis());
    }

    /**
     * generate a unique guid with a two letter prefix passed in.
     *
     * @return a random Sid with given prefix
     */
    public static String generateGUID(String prefix, String randomString) {
        if (prefix.length() > 2) {
            prefix = prefix.substring(0, 2);
        }
        return prefix + generateGuidHash(randomString);
    }
}