/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import androidx.annotation.NonNull;
import com.twilio.voice.AudioCodec;
import com.twilio.voice.CallInvite;
import com.twilio.voice.CallOptions;
import com.twilio.voice.IceOptions;
import com.twilio.voice.LocalAudioTrack;
import com.twilio.voice.PlatformInfo;
import com.twilio.voice.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AcceptOptions
extends CallOptions {
    private final Map<String, String> callInviteMessage;

    private AcceptOptions() {
        this.callInviteMessage = null;
    }

    private AcceptOptions(Builder builder) {
        this.audioTracks = builder.audioTracks != null ? builder.audioTracks : new ArrayList();
        this.iceOptions = builder.iceOptions;
        this.enableDscp = builder.enableDscp;
        this.enableIceGatheringOnAnyAddressPorts = builder.enableIceGatheringOnAnyAddressPorts;
        this.preferredAudioCodecs = builder.preferredAudioCodecs;
        this.callInviteMessage = builder.callInvite == null ? new HashMap() : builder.callInvite.callInviteMessage;
        this.platformInfo = new PlatformInfo();
    }

    private long createNativeAcceptOptionsBuilder() {
        AcceptOptions.checkAudioTracksReleased(this.audioTracks);
        return this.nativeCreate(this.getLocalAudioTracksArray(), this.iceOptions, this.enableDscp, this.enableIceGatheringOnAnyAddressPorts, this.getAudioCodecsArray(), this.platformInfo);
    }

    private native long nativeCreate(LocalAudioTrack[] var1, IceOptions var2, boolean var3, boolean var4, AudioCodec[] var5, PlatformInfo var6);

    public static class Builder
    extends CallOptions.Builder {
        private final CallInvite callInvite;

        public Builder() {
            this.callInvite = null;
        }

        Builder(@NonNull CallInvite callInvite, boolean reject) {
            Preconditions.checkNotNull(callInvite);
            this.callInvite = callInvite;
        }

        @Override
        @NonNull
        Builder audioTracks(@NonNull List<LocalAudioTrack> audioTracks) {
            Preconditions.checkNotNull(audioTracks, "audioTracks must not be null");
            super.audioTracks(audioTracks);
            return this;
        }

        @Override
        @NonNull
        public Builder iceOptions(@NonNull IceOptions iceOptions) {
            Preconditions.checkNotNull(iceOptions, "iceOptions must not be null");
            super.iceOptions(iceOptions);
            return this;
        }

        @Override
        @NonNull
        public Builder enableDscp(@NonNull boolean enable) {
            super.enableDscp(enable);
            return this;
        }

        @Override
        @NonNull
        public Builder enableIceGatheringOnAnyAddressPorts(@NonNull boolean enable) {
            super.enableIceGatheringOnAnyAddressPorts(enable);
            return this;
        }

        @Override
        @NonNull
        public Builder preferAudioCodecs(@NonNull List<AudioCodec> preferredAudioCodecs) {
            Preconditions.checkNotNull(preferredAudioCodecs, "preferredAudioCodecs must not be null");
            CallOptions.checkAudioCodecs(preferredAudioCodecs);
            super.preferAudioCodecs(preferredAudioCodecs);
            return this;
        }

        @NonNull
        public AcceptOptions build() {
            CallOptions.checkAudioTracksReleased(this.audioTracks);
            return new AcceptOptions(this);
        }
    }
}

