/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.twilio.voice.AcceptOptions;
import com.twilio.voice.Call;
import com.twilio.voice.CallException;
import com.twilio.voice.CallInviteProxy;
import com.twilio.voice.CallerInfo;
import com.twilio.voice.InternalCall;
import com.twilio.voice.LocalAudioTrack;
import com.twilio.voice.Logger;
import com.twilio.voice.Preconditions;
import com.twilio.voice.Utils;
import com.twilio.voice.Voice;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CallInvite
implements Parcelable {
    private static final Logger logger = Logger.getLogger(InternalCall.class);
    private final String bridgeToken;
    private final String callSid;
    private final String from;
    private final String to;
    private final String messageSid;
    private final String stirStatus;
    private CallerInfo callerInfo;
    @VisibleForTesting
    final Map<String, String> callInviteMessage;
    final Map<String, String> customParameters;
    private final Call.Listener callListenerProxy = new Call.Listener(){

        @Override
        public void onRinging(@NonNull Call call) {
        }

        @Override
        public void onConnected(@NonNull Call call) {
        }

        @Override
        public void onReconnecting(@NonNull Call call, @NonNull CallException callException) {
        }

        @Override
        public void onReconnected(@NonNull Call call) {
        }

        @Override
        public void onConnectFailure(@NonNull Call call, @NonNull CallException callException) {
            call.release();
        }

        @Override
        public void onDisconnected(@NonNull Call call, CallException callException) {
            call.release();
        }

        @Override
        public void onCallQualityWarningsChanged(Call call, Set<Call.CallQualityWarning> currentWarnings, Set<Call.CallQualityWarning> previousWarnings) {
        }
    };
    Call.EventListener eventListenerProxy = new Call.EventListener(){

        @Override
        public void onEvent(Map<String, Pair<String, Class>> data) {
        }

        @Override
        public void onMetric(Map<String, Pair<String, Class>> data) {
        }
    };
    public static final Parcelable.Creator CREATOR = new Parcelable.Creator(){

        public CallInvite createFromParcel(Parcel in) {
            return new CallInvite(in);
        }

        public CallInvite[] newArray(int size) {
            return new CallInvite[size];
        }
    };

    static CallInvite create(Map<String, String> data) {
        return new CallInvite(data);
    }

    private CallInvite(Map<String, String> data) {
        this.from = data.get("twi_from");
        this.to = data.get("twi_to");
        this.callSid = data.get("twi_call_sid");
        this.bridgeToken = data.get("twi_bridge_token");
        this.messageSid = data.get("twi_message_id");
        this.stirStatus = data.get("twi_stir_status");
        this.callerInfo = new CallerInfo(this.stirStatus);
        this.customParameters = new HashMap<String, String>();
        String queryPairs = data.get("twi_params");
        if (queryPairs != null) {
            Utils.parseCustomParams(queryPairs, this.customParameters);
        }
        this.callInviteMessage = data;
    }

    private CallInvite(Parcel in) {
        String[] data = new String[6];
        in.readStringArray(data);
        this.from = data[0];
        this.to = data[1];
        this.callSid = data[2];
        this.bridgeToken = data[3];
        this.messageSid = data[4];
        this.stirStatus = data[5];
        this.callerInfo = new CallerInfo(this.stirStatus);
        int size = in.readInt();
        this.callInviteMessage = new HashMap<String, String>(size);
        for (int i = 0; i < size; ++i) {
            String key = in.readString();
            String value = in.readString();
            this.callInviteMessage.put(key, value);
        }
        int sizeOfCustomParams = in.readInt();
        this.customParameters = new HashMap<String, String>(sizeOfCustomParams);
        for (int i = 0; i < sizeOfCustomParams; ++i) {
            String key = in.readString();
            String value = in.readString();
            this.customParameters.put(key, value);
        }
    }

    @Nullable
    public String getFrom() {
        return this.from;
    }

    @NonNull
    public String getTo() {
        return this.to;
    }

    @NonNull
    public String getCallSid() {
        return this.callSid;
    }

    @NonNull
    String getMessageSid() {
        return this.messageSid;
    }

    @NonNull
    public CallerInfo getCallerInfo() {
        return this.callerInfo;
    }

    @NonNull
    public Map<String, String> getCustomParameters() {
        return this.customParameters;
    }

    String getBridgeToken() {
        return this.bridgeToken;
    }

    @NonNull
    public synchronized Call accept(@NonNull Context context, @NonNull AcceptOptions acceptOptions, @NonNull Call.Listener listener) {
        return this.accept(context, acceptOptions, listener, this.eventListenerProxy);
    }

    @NonNull
    public synchronized Call accept(@NonNull Context context, @NonNull Call.Listener listener) {
        return this.accept(context, new AcceptOptions.Builder().build(), listener);
    }

    public synchronized void reject(@NonNull Context context) {
        this.reject(context, this.callListenerProxy, this.eventListenerProxy);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeStringArray(new String[]{this.from, this.to, this.callSid, this.bridgeToken, this.messageSid, this.stirStatus});
        dest.writeInt(this.callInviteMessage.size());
        for (Map.Entry<String, String> entry : this.callInviteMessage.entrySet()) {
            dest.writeString(entry.getKey());
            dest.writeString(entry.getValue());
        }
        if (this.customParameters != null) {
            dest.writeInt(this.customParameters.size());
            for (Map.Entry<String, String> entry : this.customParameters.entrySet()) {
                dest.writeString(entry.getKey());
                dest.writeString(entry.getValue());
            }
        }
    }

    @VisibleForTesting
    @NonNull
    synchronized Call accept(@NonNull Context context, @NonNull AcceptOptions acceptOptions, final @NonNull Call.Listener listener, @NonNull Call.EventListener eventListener) {
        Preconditions.checkNotNull(context, "context must not be null");
        Preconditions.checkNotNull(acceptOptions, "acceptOptions must not be null");
        Preconditions.checkNotNull(listener, "listener must not be null");
        if (!Utils.isAudioPermissionGranted(context)) {
            throw new SecurityException("Requires the RECORD_AUDIO permission");
        }
        final Call call = new Call(context.getApplicationContext(), this, listener);
        CallInviteProxy callInviteProxy = Voice.callInviteProxyMap.get(this.callSid);
        if (callInviteProxy != null) {
            AcceptOptions.Builder acceptOptionsBuilder = new AcceptOptions.Builder(this, false);
            if (acceptOptions.getIceOptions() != null) {
                acceptOptionsBuilder.iceOptions(acceptOptions.getIceOptions());
            }
            if (acceptOptions.getPreferredAudioCodecs() != null) {
                acceptOptionsBuilder.preferAudioCodecs((List)acceptOptions.getPreferredAudioCodecs());
            }
            acceptOptionsBuilder.enableDscp(acceptOptions.enableDscp);
            acceptOptionsBuilder.enableIceGatheringOnAnyAddressPorts(acceptOptions.enableIceGatheringOnAnyAddressPorts);
            LocalAudioTrack localAudioTrack = LocalAudioTrack.create(context, true);
            acceptOptionsBuilder.audioTracks((List)Collections.singletonList(localAudioTrack));
            AcceptOptions internalAcceptOptions = acceptOptionsBuilder.build();
            callInviteProxy.setCall(call);
            callInviteProxy.setEventListener(eventListener);
            call.accept(internalAcceptOptions, callInviteProxy.nativeCallInviteProxy);
            callInviteProxy.release(this.callSid);
        } else {
            Utils.createHandler().post(new Runnable(){

                @Override
                public void run() {
                    logger.d("Attempted to accept CallInvite that was previously accepted,rejected, or cancelled.");
                    call.state = Call.State.DISCONNECTED;
                    listener.onConnectFailure(call, CallException.CallCancelledException);
                }
            });
        }
        return call;
    }

    @VisibleForTesting
    void reject(@NonNull Context context, final @NonNull Call.Listener listener, @NonNull Call.EventListener eventListener) {
        Preconditions.checkNotNull(context, "context must not be null");
        Preconditions.checkNotNull(context, "listener must not be null");
        Preconditions.checkNotNull(context, "eventListener must not be null");
        final Call call = new Call(context.getApplicationContext(), this, listener);
        CallInviteProxy callInviteProxy = Voice.callInviteProxyMap.get(this.callSid);
        if (callInviteProxy != null) {
            AcceptOptions.Builder acceptOptionsBuilder = new AcceptOptions.Builder(this, true);
            AcceptOptions acceptOptions = acceptOptionsBuilder.build();
            callInviteProxy.setEventListener(eventListener);
            call.reject(acceptOptions, callInviteProxy.nativeCallInviteProxy);
            callInviteProxy.release(this.callSid);
        } else {
            Utils.createHandler().post(new Runnable(){

                @Override
                public void run() {
                    logger.d("Attempted to reject CallInvite that was previously accepted,rejected, or cancelled.");
                    call.state = Call.State.DISCONNECTED;
                    listener.onConnectFailure(call, CallException.CallCancelledException);
                }
            });
        }
    }

    public static boolean isValid(Context context, Bundle data) {
        Preconditions.checkNotNull(context, "context must not be null");
        Preconditions.checkNotNull(data, "data must not be null");
        return CallInvite.isValid(context, Utils.bundleToMap(data));
    }

    public static boolean isValid(Context context, Map<String, String> data) {
        Preconditions.checkNotNull(context, "context must not be null");
        Preconditions.checkNotNull(data, "data must not be null");
        Pair<String[], String[]> dataKeyValues = Utils.mapToArrays(data);
        Voice.loadLibrary(context);
        return CallInvite.nativeIsValid((String[])dataKeyValues.first, (String[])dataKeyValues.second);
    }

    public boolean equals(Object o) {
        if (o instanceof CallInvite) {
            CallInvite callInvite = (CallInvite)o;
            return this.getFrom().equals(callInvite.getFrom()) && this.getTo().equals(callInvite.getTo()) && this.getCallSid().equals(callInvite.getCallSid());
        }
        return false;
    }

    private static native boolean nativeIsValid(String[] var0, String[] var1);
}

