/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.twilio.voice.Utils;
import java.util.HashMap;
import java.util.Map;

public class CancelledCallInvite
implements Parcelable {
    private final String from;
    private final String to;
    private final String callSid;
    final Map<String, String> cancelledCallInviteMessage;
    final Map<String, String> customParameters;
    public static final Parcelable.Creator CREATOR = new Parcelable.Creator(){

        public CancelledCallInvite createFromParcel(Parcel in) {
            return new CancelledCallInvite(in);
        }

        public CancelledCallInvite[] newArray(int size) {
            return new CancelledCallInvite[size];
        }
    };

    @Nullable
    public String getFrom() {
        return this.from;
    }

    @NonNull
    public String getTo() {
        return this.to;
    }

    @NonNull
    public String getCallSid() {
        return this.callSid;
    }

    @NonNull
    public Map<String, String> getCustomParameters() {
        return this.customParameters;
    }

    static CancelledCallInvite create(Map<String, String> data) {
        return new CancelledCallInvite(data);
    }

    private CancelledCallInvite(Map<String, String> data) {
        this.from = data.get("twi_from");
        this.to = data.get("twi_to");
        this.callSid = data.get("twi_call_sid");
        this.customParameters = new HashMap<String, String>();
        String queryPairs = data.get("twi_params");
        if (queryPairs != null) {
            Utils.parseCustomParams(queryPairs, this.customParameters);
        }
        this.cancelledCallInviteMessage = data;
    }

    private CancelledCallInvite(Parcel in) {
        String[] data = new String[3];
        in.readStringArray(data);
        this.from = data[0];
        this.to = data[1];
        this.callSid = data[2];
        int size = in.readInt();
        this.cancelledCallInviteMessage = new HashMap<String, String>(size);
        for (int i = 0; i < size; ++i) {
            String key = in.readString();
            String value = in.readString();
            this.cancelledCallInviteMessage.put(key, value);
        }
        int sizeOfCustomParams = in.readInt();
        this.customParameters = new HashMap<String, String>(sizeOfCustomParams);
        for (int i = 0; i < sizeOfCustomParams; ++i) {
            String key = in.readString();
            String value = in.readString();
            this.customParameters.put(key, value);
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeStringArray(new String[]{this.from, this.to, this.callSid});
        dest.writeInt(this.cancelledCallInviteMessage.size());
        for (Map.Entry<String, String> entry : this.cancelledCallInviteMessage.entrySet()) {
            dest.writeString(entry.getKey());
            dest.writeString(entry.getValue());
        }
        if (this.customParameters != null) {
            dest.writeInt(this.customParameters.size());
            for (Map.Entry<String, String> entry : this.customParameters.entrySet()) {
                dest.writeString(entry.getKey());
                dest.writeString(entry.getValue());
            }
        }
    }

    public boolean equals(Object o) {
        if (o instanceof CancelledCallInvite) {
            CancelledCallInvite cancelledCallInvite = (CancelledCallInvite)o;
            return this.getFrom().equals(cancelledCallInvite.getFrom()) && this.getTo().equals(cancelledCallInvite.getTo()) && this.getCallSid().equals(cancelledCallInvite.getCallSid());
        }
        return false;
    }

    static boolean isValid(Map<String, String> data) {
        String messageType = data.get("twi_message_type");
        String callSid = data.get("twi_call_sid");
        String to = data.get("twi_to");
        return messageType != null && messageType.equals("twilio.voice.cancel") && callSid != null && to != null;
    }
}

