/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

abstract class Constants {
    public static int CALL_SID_LENGTH = 34;
    public static final boolean dev = true;
    private static final String KEY_NOTIFICATION_SERVICE_HOST = "notification-service";
    private static final String KEY_KIBANA_METRICS_HOST_URL = "kibana-metrics-host";
    private static final String KEY_KIBANA_EVENT_GATEWAY_HOST_URL = "kibana-event-gateway-host";
    private static final String TWILIO_DEFAULT_KIBANA_METRICS_HOST_URL = "https://eventgw.twilio.com/v4/EndpointMetrics";
    private static final String TWILIO_DEFAULT_KIBANA_EVENT_GATEWAY_HOST_URL = "https://eventgw.twilio.com/v4/EndpointEvents";
    static final String TWILIO_REQUEST_HEADER = "X-Twilio-Request-Id";
    static final String TWILIO_REQUEST_SID_PREFIX = "RQ";
    private static final String DEFAULT_NOTIFICATION_SERVICE_HOST_URL = "https://ers.twilio.com";
    public static String GLOBAL_LOW_LATENCY_REGION = "gll";
    public static String EDGE_ROAMING = "roaming";
    public static String GLOBAL_ENV = "com.twilio.voice.env";
    public static String GLOBAL_ENV_SDK = "com.twilio.voice.env.sdk";
    private static Map<String, String> params = new HashMap<String, String>();
    public static final String CLIENT_SDK_PRODUCT_NAME_DEFAULT = "twilio-voice-android";
    public static final String APP_JSON_PAYLOAD_TYPE = "application/json";
    public static final String PLATFORM_ANDROID = "android";

    Constants() {
    }

    public static final String getNotificationServiceUrl() {
        return params.containsKey(KEY_NOTIFICATION_SERVICE_HOST) ? params.get(KEY_NOTIFICATION_SERVICE_HOST) : DEFAULT_NOTIFICATION_SERVICE_HOST_URL;
    }

    public static final String getKeyKibanaMetricsHostUrl() {
        return params.containsKey(KEY_KIBANA_METRICS_HOST_URL) ? params.get(KEY_KIBANA_METRICS_HOST_URL) : TWILIO_DEFAULT_KIBANA_METRICS_HOST_URL;
    }

    public static final String getKeyKibanaEventGatewayHostUrl() {
        return params.containsKey(KEY_KIBANA_EVENT_GATEWAY_HOST_URL) ? params.get(KEY_KIBANA_EVENT_GATEWAY_HOST_URL) : TWILIO_DEFAULT_KIBANA_EVENT_GATEWAY_HOST_URL;
    }

    private static final void setDevParams(Map<String, String> params) {
        Constants.params = Collections.unmodifiableMap(params);
    }

    static String getClientSdkProductName() {
        String env = System.getProperty(GLOBAL_ENV, GLOBAL_ENV_SDK);
        if (!env.equals(GLOBAL_ENV_SDK)) {
            return String.format("%s-%s", CLIENT_SDK_PRODUCT_NAME_DEFAULT, env);
        }
        return CLIENT_SDK_PRODUCT_NAME_DEFAULT;
    }

    public static enum Direction {
        INCOMING,
        OUTGOING;

    }

    public static enum SeverityLevel {
        INFO,
        DEBUG,
        WARNING,
        ERROR;

    }
}

