/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import android.content.Context;
import android.os.Handler;
import androidx.annotation.VisibleForTesting;
import com.twilio.voice.Call;
import com.twilio.voice.Constants;
import com.twilio.voice.Event;
import com.twilio.voice.EventPayload;
import com.twilio.voice.EventPublisher;
import com.twilio.voice.InsightsUtils;
import com.twilio.voice.Logger;
import com.twilio.voice.RTCStatsSample;
import com.twilio.voice.Utils;
import com.twilio.voice.Voice;
import com.twilio.voice.VoiceException;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONObject;

abstract class InternalCall
implements EventPublisher.EventPublisherListener {
    private static final Logger logger = Logger.getLogger(InternalCall.class);
    private static final String TEMP_CALL_SID_PREFIX = "TSID";
    String sid;
    String bridgeToken;
    String from;
    String to;
    String selectedRegion = Voice.region;
    String gateway;
    String region;
    String codecParams;
    String selectedCodec;
    Handler handler;
    Context context;
    boolean isMuted;
    boolean isOnHold;
    Call.State state;
    boolean disconnectCalled;
    EventPublisher publisher;
    Constants.Direction direction;
    private JSONArray payload;
    private final UUID uuid = UUID.randomUUID();
    private final String tempCallSid = "TSID" + this.uuid;
    private int sampleCounter;

    InternalCall() {
    }

    void setSid(String sid) {
        this.sid = sid;
    }

    boolean isValidState() {
        return this.state != Call.State.DISCONNECTED;
    }

    public abstract String getSid();

    public abstract void sendDigits(String var1);

    public abstract Call.State getState();

    public abstract boolean isMuted();

    public abstract void mute(boolean var1);

    public abstract void disconnect();

    @Override
    public void onError(VoiceException voiceException) {
        logger.e("Error publishing data : " + voiceException.getMessage() + ":" + voiceException.getErrorCode());
    }

    void onSample(RTCStatsSample currentSample) {
        ++this.sampleCounter;
        this.payload = InsightsUtils.publishMetrics(currentSample, this.sampleCounter, this.sid, this.direction, this.payload, this.publisher);
    }

    void publishFeedbackEvent(Call.Score score, Call.Issue issue) {
        String eventName;
        EventPayload eventPayload;
        logger.d("Publishing event feedback event");
        if (score == Call.Score.NOT_REPORTED && issue == Call.Issue.NOT_REPORTED) {
            eventPayload = this.createEventPayloadBuilder().build();
            eventName = "received-none";
        } else {
            eventPayload = this.createEventPayloadBuilder().score(score).issue(issue).build();
            eventName = "received";
        }
        try {
            JSONObject connectionEventPayload = eventPayload.getPayload();
            Event event = this.publisher.createEvent(Constants.SeverityLevel.INFO, "feedback", eventName, connectionEventPayload);
            this.publisher.publish(Constants.SeverityLevel.INFO, "feedback", eventName, event);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    EventPayload.Builder createEventPayloadBuilder() {
        return new EventPayload.Builder().callSid(this.sid).tempCallSid(this.tempCallSid).direction(this.direction).selectedRegion(this.selectedRegion).gateway(this.gateway).region(this.region).productName(Constants.getClientSdkProductName()).clientName(Utils.parseClientIdentity(this.to)).payLoadType("application/json");
    }

    EventPayload.Builder createEventPayloadBuilderForSettingsEvent() {
        return this.createEventPayloadBuilder().codecParams(this.codecParams).selectedCodec(this.selectedCodec);
    }

    @VisibleForTesting
    EventPublisher getPublisher() {
        return this.publisher;
    }
}

