/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import android.os.Handler;
import com.twilio.voice.AccessTokenParseException;
import com.twilio.voice.AccessTokenParser;
import com.twilio.voice.Constants;
import com.twilio.voice.HttpsRegistrar;
import com.twilio.voice.RegistrarListener;
import com.twilio.voice.Registration;
import com.twilio.voice.RegistrationException;
import com.twilio.voice.RegistrationListener;
import com.twilio.voice.UnregistrationListener;
import com.twilio.voice.Utils;

class Registrar
implements RegistrarListener {
    static final String RELATIVE_REGISTER_URL = "/v1/registrations?productId=voice";
    private static final String RELATIVE_UNREGISTER_URL = "?productId=voice";
    private final Handler handler;
    private final String accessToken;
    private final String channelType;
    private final String notificationToken;
    private String homeRegion;
    String urlString;
    private RegistrationListener registrationListener;
    private UnregistrationListener unregistrationListener;

    public Registrar(String accessToken, String channelType, String notificationToken) {
        this.accessToken = accessToken;
        this.channelType = channelType;
        this.notificationToken = notificationToken;
        this.handler = Utils.createHandler();
        try {
            this.homeRegion = new AccessTokenParser(accessToken).getHomeRegion();
        }
        catch (AccessTokenParseException e) {
            e.printStackTrace();
        }
        this.urlString = this.homeRegion == null ? Constants.getNotificationServiceUrl() + RELATIVE_REGISTER_URL : String.format("https://ers.%s.twilio.com/v1/registrations?productId=voice", this.homeRegion);
    }

    public void register(RegistrationListener listener) {
        this.registrationListener = listener;
        String jsonPayloadString = new Registration(this.channelType, this.notificationToken).toJson().toString();
        HttpsRegistrar.register(this.accessToken, jsonPayloadString, this.urlString, this);
    }

    public void unregister(UnregistrationListener listener) {
        this.unregistrationListener = listener;
        String jsonPayloadString = new Registration(this.channelType, this.notificationToken).toJson().toString();
        boolean isUnregistrationRequest = true;
        HttpsRegistrar.register(this.accessToken, jsonPayloadString, this.urlString, isUnregistrationRequest, new RegistrarListener(){

            @Override
            public void onSuccess(String registrationLocation) {
                String urlString = registrationLocation + Registrar.RELATIVE_UNREGISTER_URL;
                HttpsRegistrar.unregister(Registrar.this.accessToken, urlString, Registrar.this);
            }

            @Override
            public void onError(RegistrationException registrationException) {
                Registrar.this.onError(registrationException);
            }
        });
    }

    @Override
    public void onSuccess(String registrationLocation) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                if (Registrar.this.registrationListener != null) {
                    Registrar.this.registrationListener.onRegistered(Registrar.this.accessToken, Registrar.this.notificationToken);
                } else {
                    Registrar.this.unregistrationListener.onUnregistered(Registrar.this.accessToken, Registrar.this.notificationToken);
                }
            }
        });
    }

    @Override
    public void onError(final RegistrationException registrationException) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                if (Registrar.this.registrationListener != null) {
                    Registrar.this.registrationListener.onError(registrationException, Registrar.this.accessToken, Registrar.this.notificationToken);
                } else {
                    Registrar.this.unregistrationListener.onError(registrationException, Registrar.this.accessToken, Registrar.this.notificationToken);
                }
            }
        });
    }
}

