/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.getkeepsafe.relinker.ReLinker;
import com.twilio.voice.AudioDevice;
import com.twilio.voice.Call;
import com.twilio.voice.CallInvite;
import com.twilio.voice.CallInviteProxy;
import com.twilio.voice.CancelledCallInvite;
import com.twilio.voice.ConnectOptions;
import com.twilio.voice.Constants;
import com.twilio.voice.DefaultAudioDevice;
import com.twilio.voice.LocalAudioTrack;
import com.twilio.voice.LogLevel;
import com.twilio.voice.LogModule;
import com.twilio.voice.Logger;
import com.twilio.voice.MediaFactory;
import com.twilio.voice.MessageListener;
import com.twilio.voice.Preconditions;
import com.twilio.voice.Registrar;
import com.twilio.voice.RegistrationListener;
import com.twilio.voice.UnregistrationListener;
import com.twilio.voice.Utils;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class Voice {
    static AtomicInteger networkChangedCount = new AtomicInteger(0);
    static Map<LogModule, LogLevel> moduleLogLevel = new EnumMap<LogModule, LogLevel>(LogModule.class);
    private static final LogLevel defaultLogLevel;
    static LogLevel level;
    static boolean enableInsights;
    static String region;
    static String edge;
    static boolean isLibraryLoaded;
    static final Set<Call> calls;
    static Pair<String, String> callSidBridgeTokenPair;
    static final Map<String, CallInviteProxy> callInviteProxyMap;
    static final Set<Call> rejects;
    static AudioDevice audioDevice;

    Voice() {
    }

    public static void register(@NonNull String accessToken, @NonNull RegistrationChannel registrationChannel, @NonNull String registrationToken, @NonNull RegistrationListener listener) {
        Preconditions.checkNotNull(accessToken, "accessToken must not be null");
        Preconditions.checkNotNull(registrationChannel, "registrationChannel must not be null");
        Preconditions.checkNotNull(registrationToken, "registrationToken must not be null");
        Preconditions.checkNotNull(listener, "listener must not be null");
        Registrar registrar = new Registrar(accessToken, registrationChannel.toString(), registrationToken);
        registrar.register(listener);
    }

    public static void unregister(@NonNull String accessToken, @NonNull RegistrationChannel registrationChannel, @NonNull String registrationToken, @NonNull UnregistrationListener listener) {
        Preconditions.checkNotNull(accessToken, "accessToken must not be null");
        Preconditions.checkNotNull(registrationChannel, "registrationChannel must not be null");
        Preconditions.checkNotNull(registrationToken, "registrationToken must not be null");
        Preconditions.checkNotNull(listener, "listener must not be null");
        Registrar registrar = new Registrar(accessToken, registrationChannel.toString(), registrationToken);
        registrar.unregister(listener);
    }

    @NonNull
    public static Call connect(@NonNull Context context, @NonNull ConnectOptions connectOptions, @NonNull Call.Listener listener) {
        Preconditions.checkNotNull(context, "context must not be null");
        Preconditions.checkNotNull(connectOptions, "connectOptions must not be null");
        Preconditions.checkNotNull(listener, "listener must not be null");
        if (!Utils.isAudioPermissionGranted(context)) {
            throw new SecurityException("Requires the RECORD_AUDIO permission");
        }
        ConnectOptions.Builder builder = new ConnectOptions.Builder(connectOptions.getAccessToken());
        builder.params(connectOptions.getParams());
        if (connectOptions.getIceOptions() != null) {
            builder.iceOptions(connectOptions.getIceOptions());
        }
        if (connectOptions.getPreferredAudioCodecs() != null) {
            builder.preferAudioCodecs((List)connectOptions.getPreferredAudioCodecs());
        }
        builder.enableDscp(connectOptions.enableDscp);
        builder.enableIceGatheringOnAnyAddressPorts(connectOptions.enableIceGatheringOnAnyAddressPorts);
        LocalAudioTrack localAudioTrack = LocalAudioTrack.create(context, true);
        builder.audioTracks((List)Collections.singletonList(localAudioTrack));
        builder.eventListener(connectOptions.getEventListener());
        ConnectOptions internalConnectOptions = builder.build();
        Call call = new Call(context.getApplicationContext(), internalConnectOptions.getAccessToken(), listener);
        call.connect(internalConnectOptions);
        return call;
    }

    @NonNull
    public static Call connect(@NonNull Context context, @NonNull String accessToken, @NonNull Call.Listener listener) {
        return Voice.connect(context, new ConnectOptions.Builder(accessToken).build(), listener);
    }

    public static synchronized boolean handleMessage(@NonNull Context context, @NonNull Map<String, String> data, @NonNull MessageListener listener) {
        return Voice.handleMessage(context, data, listener, null);
    }

    public static boolean handleMessage(@NonNull Context context, @NonNull Bundle data, @NonNull MessageListener listener) {
        Preconditions.checkNotNull(context, "context must not be null");
        Preconditions.checkNotNull(data, "data must not be null");
        Preconditions.checkNotNull(listener, "listener must not be null");
        return Voice.handleMessage(context, Utils.bundleToMap(data), listener);
    }

    @NonNull
    public static String getVersion() {
        return "6.1.3";
    }

    @NonNull
    public static LogLevel getLogLevel() {
        return level;
    }

    @NonNull
    public static LogLevel getModuleLogLevel(LogModule module) {
        if (moduleLogLevel.containsKey((Object)module)) {
            return moduleLogLevel.get((Object)module);
        }
        return defaultLogLevel;
    }

    public static boolean isInsightsEnabled() {
        return enableInsights;
    }

    @Deprecated
    @NonNull
    public static String getRegion() {
        return region;
    }

    @NonNull
    public static String getEdge() {
        return edge;
    }

    @NonNull
    public static AudioDevice getAudioDevice() {
        if (audioDevice == null) {
            audioDevice = new DefaultAudioDevice();
        }
        return audioDevice;
    }

    public static void setLogLevel(@NonNull LogLevel level) {
        Voice.setSDKLogLevel(level);
        if (isLibraryLoaded) {
            Voice.nativeSetModuleLevel(LogModule.CORE.ordinal(), level.ordinal());
        }
        Voice.level = level;
    }

    public static void setModuleLogLevel(@NonNull LogModule module, @NonNull LogLevel level) {
        if (module == LogModule.PLATFORM) {
            Voice.setSDKLogLevel(level);
        }
        if (isLibraryLoaded) {
            Voice.nativeSetModuleLevel(module.ordinal(), level.ordinal());
        }
        moduleLogLevel.put(module, level);
    }

    public static void enableInsights(boolean enable) {
        if (isLibraryLoaded) {
            Voice.nativeEnableInsights(enable);
        }
        enableInsights = enable;
    }

    @Deprecated
    public static void setRegion(@NonNull String region) {
        Preconditions.checkNotNull(region, "region must not be null");
        Preconditions.checkArgument(edge.equals(Constants.EDGE_ROAMING), String.format("Non default edge value %s has already been specified. Please use Voice.edge or Voice.region to specify the Twilio Region that the SDK connects to.", Voice.getEdge()));
        if (isLibraryLoaded) {
            Voice.nativeSetRegion(region);
        }
        Voice.region = region;
    }

    public static void setEdge(@NonNull String edge) {
        Preconditions.checkNotNull(edge, "edge must not be null");
        Preconditions.checkArgument(region.equals(Constants.GLOBAL_LOW_LATENCY_REGION), String.format("Non default region value %s has already been specified. Please use Voice.edge or Voice.region to specify the Twilio Region that the SDK connects to.", Voice.getRegion()));
        if (isLibraryLoaded) {
            Voice.nativeSetEdge(edge);
        }
        Voice.edge = edge;
    }

    public static void setAudioDevice(@NonNull AudioDevice audioDevice) throws UnsupportedOperationException {
        Preconditions.checkNotNull(audioDevice, "audioDevice must not be null");
        if (!calls.isEmpty()) {
            throw new UnsupportedOperationException("Changing the audio device during a call is not allowed");
        }
        Voice.audioDevice = audioDevice;
    }

    private static void setSDKLogLevel(LogLevel level) {
        switch (level) {
            case OFF: {
                Logger.setLogLevel(7);
                break;
            }
            case ERROR: {
                Logger.setLogLevel(6);
                break;
            }
            case WARNING: {
                Logger.setLogLevel(5);
                break;
            }
            case INFO: {
                Logger.setLogLevel(4);
                break;
            }
            case DEBUG: {
                Logger.setLogLevel(3);
                break;
            }
            case TRACE: {
                Logger.setLogLevel(2);
                break;
            }
            case ALL: {
                Logger.setLogLevel(2);
                break;
            }
            default: {
                Logger.setLogLevel(7);
            }
        }
    }

    static void onNetworkChanged(NetworkChangeEvent networkChangeEvent) {
        networkChangedCount.incrementAndGet();
        for (Call call : calls) {
            call.networkChange(networkChangeEvent);
        }
        for (CallInviteProxy callInviteProxy : callInviteProxyMap.values()) {
            callInviteProxy.networkChange(networkChangeEvent);
        }
    }

    static void loadLibrary(Context context) {
        if (!isLibraryLoaded) {
            ReLinker.loadLibrary((Context)context, (String)"twilio_voice_android_so");
            isLibraryLoaded = true;
            Voice.setLogLevel(level);
            if (!edge.equals(Constants.EDGE_ROAMING)) {
                Voice.nativeSetEdge(edge);
            }
            if (!region.equals(Constants.GLOBAL_LOW_LATENCY_REGION)) {
                Voice.nativeSetRegion(region);
            }
            Voice.enableInsights(enableInsights);
            for (LogModule module : moduleLogLevel.keySet()) {
                Voice.setModuleLogLevel(module, moduleLogLevel.get((Object)module));
            }
        }
    }

    @VisibleForTesting
    static synchronized boolean handleMessage(@NonNull Context context, @NonNull Map<String, String> data, @NonNull MessageListener listener, @Nullable Call.EventListener eventListener) {
        Preconditions.checkNotNull(context, "context must not be null");
        Preconditions.checkNotNull(data, "data must not be null");
        Preconditions.checkNotNull(listener, "listener must not be null");
        boolean callInviteValid = CallInvite.isValid(context, data);
        if (callInviteValid || CancelledCallInvite.isValid(data) && Voice.isInsightsEnabled()) {
            Voice.callNativeHandleMessage(context, data, listener, eventListener);
        }
        return callInviteValid;
    }

    private static void callNativeHandleMessage(final @NonNull Context context, final @NonNull Map<String, String> data, final @NonNull MessageListener listener, final Call.EventListener eventListener) {
        Voice.loadLibrary(context);
        final Handler handler = Utils.createHandler();
        handler.post(new Runnable(){

            @Override
            public void run() {
                CallInvite callInvite = CallInvite.create(data);
                CancelledCallInvite cancelledCallInvite = CancelledCallInvite.create(data);
                if (callInvite.getBridgeToken() != null) {
                    callSidBridgeTokenPair = Pair.create((Object)callInvite.getCallSid(), (Object)callInvite.getBridgeToken());
                }
                Pair<String[], String[]> dataKeyValues = Utils.mapToArrays(data);
                MediaFactory mediaFactory = MediaFactory.instance(this, context.getApplicationContext());
                Voice.nativeHandleMessage(context.getApplicationContext(), (String[])dataKeyValues.first, (String[])dataKeyValues.second, callInvite, cancelledCallInvite, handler, listener, eventListener, mediaFactory.getNativeMediaFactoryHandle());
                mediaFactory.release(this);
            }
        });
    }

    private static native void nativeEnableInsights(boolean var0);

    private static native void nativeSetRegion(String var0);

    private static native void nativeSetEdge(String var0);

    private static native void nativeSetModuleLevel(int var0, int var1);

    private static native boolean nativeHandleMessage(Context var0, String[] var1, String[] var2, CallInvite var3, CancelledCallInvite var4, Handler var5, MessageListener var6, Call.EventListener var7, long var8);

    static {
        level = defaultLogLevel = LogLevel.ERROR;
        enableInsights = true;
        region = Constants.GLOBAL_LOW_LATENCY_REGION;
        edge = Constants.EDGE_ROAMING;
        isLibraryLoaded = false;
        calls = new HashSet<Call>();
        callInviteProxyMap = new HashMap<String, CallInviteProxy>();
        rejects = new HashSet<Call>();
    }

    static enum NetworkChangeEvent {
        CONNECTION_LOST,
        CONNECTION_CHANGED;

    }

    public static enum RegistrationChannel {
        FCM,
        GCM;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

