/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

public class VoiceException
extends Exception {
    public static final int EXCEPTION_INVALID_ACCESS_TOKEN = 20101;
    public static final int EXCEPTION_INVALID_ACCESS_TOKEN_HEADER = 20102;
    public static final int EXCEPTION_INVALID_ISSUER_SUBJECT = 20103;
    public static final int EXCEPTION_INVALID_ACCESS_TOKEN_EXPIRY = 20104;
    public static final int EXCEPTION_INVALID_ACCESS_TOKEN_NOT_VALID_YET = 20105;
    public static final int EXCEPTION_INVALID_ACCESS_TOKEN_GRANT = 20106;
    public static final int EXCEPTION_INVALID_SIGNATURE = 20107;
    public static final int EXCEPTION_AUTH_FAILURE = 20151;
    public static final int EXCEPTION_INVALID_TTL = 20157;
    public static final int EXCEPTION_INVALID_TOKEN = 20403;
    public static final int EXCEPTION_ACCESS_TOKEN_REJECTED = 51007;
    public static final int EXCEPTION_BAD_REQUEST = 31400;
    public static final int EXCEPTION_FORBIDDEN = 31403;
    public static final int EXCEPTION_NOT_FOUND = 31404;
    public static final int EXCEPTION_REQUEST_TIMEOUT = 31408;
    public static final int EXCEPTION_INTERNAL_SERVER_ERROR = 31500;
    public static final int EXCEPTION_BAD_GATEWAY = 31502;
    public static final int EXCEPTION_SERVICE_UNAVAILABLE = 31503;
    public static final int EXCEPTION_GATEWAY_TIMEOUT = 31504;
    static final VoiceException InvalidAccessTokenException = new VoiceException(20101, "Invalid access token", "Twilio was unable to validate your Access Token");
    static final VoiceException InvalidAccessTokenHeaderException = new VoiceException(20102, "Invalid access token header", "The header of the Access Token provided to the Twilio API was invalid");
    static final VoiceException InvalidIssuerSubjectException = new VoiceException(20103, "Invalid access token issuer/subject", "The issuer or subject of the Access Token provided to the Twilio API was invalid");
    static final VoiceException InvalidAccessTokenExpiryException = new VoiceException(20104, "Access token expired or expiration date invalid", "The Access Token provided to the Twilio API has expired, the expiration time specified in the token was invalid");
    static final VoiceException InvalidAccessTokenNotValidYetException = new VoiceException(20105, "Access token not yet valid", "The Access Token provided to the Twilio API is not yet valid");
    static final VoiceException InvalidAccessTokenGrantException = new VoiceException(20106, "Invalid access token grants", "The Access Token signature and issuer were valid, but the grants specified in the token were invalid, unparseable, or did not authorize the action being requested");
    static final VoiceException InvalidSignatureException = new VoiceException(20107, "Invalid access token signature", "The signature for the Access Token provided was invalid");
    static final VoiceException AuthFailureException = new VoiceException(20151, "Authentication Failed", "The Authentication with the provided JWT failed");
    static final VoiceException InvalidTTLException = new VoiceException(20157, "Expiration Time Exceeds Maximum Time Allowed", "The expiration time provided when creating the JWT exceeds the maximum duration allowed");
    static final VoiceException InvalidTokenException = new VoiceException(20403, "403 Forbidden", "The account lacks permission to access the Twilio API. Typically this means the account has been suspended or closed. For assistance, please contact support");
    static final VoiceException AccessTokenRejectedException = new VoiceException(51007, "Token authentication is rejected by authentication service", "The authentication service has rejected the provided Access Token. To check whether the Access Token is structurally correct, you can use the tools available at https://jwt.io. For the details of Twilio's specific Access Token implementation including the grant format, check https://www.twilio.com/docs/iam/access-tokens");
    static final VoiceException BadRequestException = new VoiceException(31400, "Bad Request", "The request could not be understood due to malformed syntax.");
    static final VoiceException ForbiddenException = new VoiceException(31403, "Forbidden", "The server understood the request, but is refusing to fulfill it.");
    static final VoiceException NotFoundException = new VoiceException(31404, "Not Found", "The server has not found anything matching the request.");
    static final VoiceException RequestTimeoutException = new VoiceException(31408, "Request Timeout", "A request timeout occurred.");
    static final VoiceException InternalServerErrorException = new VoiceException(31500, "Internal Server Error", "The server could not fulfill the request due to some unexpected condition.");
    static final VoiceException BadGatewayException = new VoiceException(31502, "Bad Gateway", "The server is acting as a gateway or proxy, and received an invalid response from a downstream server while attempting to fulfill the request.");
    static final VoiceException ServiceUnavailableException = new VoiceException(31503, "Service Unavailable", "The server is currently unable to handle the request due to a temporary overloading or maintenance of the server.");
    static final VoiceException GatewayTimeoutException = new VoiceException(31504, "Gateway Timeout", "The server, while acting as a gateway or proxy, did not receive a timely response from an upstream server.");
    private int errorCode;
    private String errorMessage;
    private String explanation;

    VoiceException(int errorCode, String errorMessage, String explanation) {
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.explanation = explanation;
    }

    @Override
    public String getMessage() {
        return this.errorMessage;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getExplanation() {
        return this.explanation;
    }
}

