/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.chill.hadoop;

import com.twitter.chill.KryoPool;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.io.serializer.Deserializer;

public class KryoDeserializer
implements Deserializer<Object> {
    private final KryoPool kryoPool;
    private final Class<Object> klass;
    private DataInputStream inputStream;

    public KryoDeserializer(KryoPool kryoPool, Class<Object> clazz) {
        this.kryoPool = kryoPool;
        this.klass = clazz;
    }

    public void open(InputStream inputStream) throws IOException {
        this.inputStream = inputStream instanceof DataInputStream ? (DataInputStream)inputStream : new DataInputStream(inputStream);
    }

    public Object deserialize(Object object) throws IOException {
        byte[] byArray = new byte[this.inputStream.readInt()];
        this.inputStream.readFully(byArray);
        return this.kryoPool.fromBytes(byArray, this.klass);
    }

    public void close() throws IOException {
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        finally {
            this.inputStream = null;
        }
    }
}

