/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.chill.thrift;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;

public class TBaseSerializer
extends Serializer<TBase> {
    private final TSerializer serializer = new TSerializer();
    private final TDeserializer deserializer = new TDeserializer();

    public void write(Kryo kryo, Output output, TBase tBase) {
        try {
            byte[] byArray = this.serializer.serialize(tBase);
            output.writeInt(byArray.length, true);
            output.writeBytes(byArray);
        }
        catch (TException tException) {
            throw new RuntimeException(tException);
        }
    }

    public TBase read(Kryo kryo, Input input, Class<TBase> clazz) {
        try {
            TBase tBase = clazz.newInstance();
            int n = input.readInt(true);
            byte[] byArray = new byte[n];
            input.readBytes(byArray);
            this.deserializer.deserialize(tBase, byArray);
            return tBase;
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not create " + clazz, exception);
        }
    }
}

