/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.base;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.twitter.common.base.Supplier;
import com.twitter.common.quantity.Amount;
import com.twitter.common.quantity.Time;
import com.twitter.common.quantity.Unit;
import com.twitter.common.util.Clock;

public class CachingSupplier<T>
implements Supplier<T> {
    private final Supplier<T> wrapped;
    private final long expirationNanos;
    private final Clock clock;
    private long lastFetchNanos = -1L;
    private T cachedValue;

    public CachingSupplier(Supplier<T> supplier, Amount<Long, Time> amount) {
        this(supplier, amount, Clock.SYSTEM_CLOCK);
    }

    @VisibleForTesting
    CachingSupplier(Supplier<T> supplier, Amount<Long, Time> amount, Clock clock) {
        this.wrapped = (Supplier)Preconditions.checkNotNull(supplier);
        this.expirationNanos = (Long)((Amount)Preconditions.checkNotNull(amount)).as((Unit)Time.NANOSECONDS);
        Preconditions.checkArgument(((Long)amount.getValue() > 0L ? 1 : 0) != 0, (Object)"Expiration must be positive.");
        this.clock = (Clock)Preconditions.checkNotNull((Object)clock);
    }

    @Override
    public synchronized T get() {
        if (this.lastFetchNanos == -1L || this.clock.nowNanos() - this.lastFetchNanos > this.expirationNanos) {
            this.cachedValue = this.wrapped.get();
            this.lastFetchNanos = this.clock.nowNanos();
        }
        return this.cachedValue;
    }
}

