/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.base;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.twitter.common.base.Closure;
import com.twitter.common.base.ExceptionalClosure;

public final class Closures {
    private static final Closure<?> NOOP = new Closure<Object>(){

        @Override
        public void execute(Object object) {
        }
    };

    private Closures() {
    }

    public static <T> Function<T, Void> asFunction(final ExceptionalClosure<T, ?> exceptionalClosure) {
        Preconditions.checkNotNull(exceptionalClosure);
        return new Function<T, Void>(){

            public Void apply(T t) {
                try {
                    exceptionalClosure.execute(t);
                }
                catch (Exception exception) {
                    Throwables.propagate((Throwable)exception);
                }
                return null;
            }
        };
    }

    public static <T> Closure<T> combine(Closure<T> ... closureArray) {
        return Closures.combine(ImmutableList.copyOf((Object[])closureArray));
    }

    public static <T> Closure<T> combine(Iterable<Closure<T>> iterable) {
        Preconditions.checkNotNull(iterable);
        Preconditions.checkArgument((boolean)Iterables.all(iterable, (Predicate)Predicates.notNull()));
        ImmutableList immutableList = ImmutableList.copyOf(iterable);
        return new Closure<T>((Iterable)immutableList){
            final /* synthetic */ Iterable val$closuresCopy;
            {
                this.val$closuresCopy = iterable;
            }

            @Override
            public void execute(T t) {
                for (Closure closure : this.val$closuresCopy) {
                    closure.execute(t);
                }
            }
        };
    }

    public static <T> Closure<T> filter(final Predicate<T> predicate, final Closure<T> closure) {
        Preconditions.checkNotNull(predicate);
        Preconditions.checkNotNull(closure);
        return new Closure<T>(){

            @Override
            public void execute(T t) {
                if (predicate.apply(t)) {
                    closure.execute(t);
                }
            }
        };
    }

    public static <T> Closure<T> noop() {
        return NOOP;
    }
}

