/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.base;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.twitter.common.base.ExceptionalSupplier;
import com.twitter.common.base.Function;
import javax.annotation.Nullable;

public final class Either<L, R> {
    private final Optional<L> left;
    private final Optional<R> right;

    private Either(Optional<L> optional, Optional<R> optional2) {
        this.left = optional;
        this.right = optional2;
    }

    public Either<R, L> swap() {
        return new Either<R, L>(this.right, this.left);
    }

    public Optional<L> left() {
        return this.left;
    }

    public Optional<R> right() {
        return this.right;
    }

    public boolean isLeft() {
        return this.left().isPresent();
    }

    public boolean isRight() {
        return this.right().isPresent();
    }

    public L getLeft() {
        return (L)this.left().get();
    }

    public R getRight() {
        return (R)this.right().get();
    }

    public <M> Either<M, R> mapLeft(Function<? super L, M> function) {
        if (this.isLeft()) {
            return Either.left(function.apply(this.getLeft()));
        }
        Either either = this;
        return either;
    }

    public <M> Either<L, M> mapRight(Function<? super R, M> function) {
        if (this.isRight()) {
            return Either.right(function.apply(this.getRight()));
        }
        Either either = this;
        return either;
    }

    public static <L, R, T> Transformer<L, R, T> transformer(final Function<? super L, T> function, final Function<? super R, T> function2) {
        return new Transformer<L, R, T>(){

            @Override
            public T mapLeft(L l) {
                return function.apply(l);
            }

            @Override
            public T mapRight(R r) {
                return function2.apply(r);
            }
        };
    }

    public <T> T map(Transformer<? super L, ? super R, T> transformer) {
        if (this.isLeft()) {
            return transformer.mapLeft(this.getLeft());
        }
        return transformer.mapRight(this.getRight());
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof Either)) {
            return false;
        }
        Either either = (Either)object;
        return Objects.equal(this.left, either.left) && Objects.equal(this.right, either.right);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.left, this.right});
    }

    public String toString() {
        if (this.isLeft()) {
            return String.format("Left(%s)", this.getLeft());
        }
        return String.format("Right(%s)", this.getRight());
    }

    public static <L, R> Either<L, R> left(L l) {
        return new Either<L, R>(Optional.of(l), Optional.absent());
    }

    public static <L, R> Either<L, R> right(R r) {
        return new Either<L, R>(Optional.absent(), Optional.of(r));
    }

    public static <L, R> Iterable<L> lefts(Iterable<Either<L, R>> iterable) {
        return Optional.presentInstances((Iterable)Iterables.transform(iterable, (com.google.common.base.Function)new Function<Either<L, R>, Optional<L>>(){

            @Override
            public Optional<L> apply(Either<L, R> either) {
                return either.left();
            }
        }));
    }

    public static <L, R> Iterable<R> rights(Iterable<Either<L, R>> iterable) {
        return Optional.presentInstances((Iterable)Iterables.transform(iterable, (com.google.common.base.Function)new Function<Either<L, R>, Optional<R>>(){

            @Override
            public Optional<R> apply(Either<L, R> either) {
                return either.right();
            }
        }));
    }

    public static <X extends Exception, R> Either<X, R> guard(Class<X> clazz, ExceptionalSupplier<R, X> exceptionalSupplier) {
        Either<X, R> either = Either.guard(exceptionalSupplier, clazz, new Class[0]);
        return either;
    }

    public static <X extends Exception, R> Either<X, R> guard(ExceptionalSupplier<R, X> exceptionalSupplier, Class<? extends X> clazz, Class<? extends X> ... classArray) {
        return Either.guard(Lists.asList(clazz, (Object[])classArray), exceptionalSupplier);
    }

    public static <X extends Exception, R> Either<X, R> guard(Iterable<Class<? extends X>> iterable, ExceptionalSupplier<R, X> exceptionalSupplier) {
        try {
            return Either.right(exceptionalSupplier.get());
        }
        catch (Exception exception) {
            for (Class<X> clazz : iterable) {
                if (!clazz.isInstance(exception)) continue;
                Exception exception2 = (Exception)clazz.cast(exception);
                return Either.left(exception2);
            }
            throw new UnguardedException(exception);
        }
    }

    public static class UnguardedException
    extends RuntimeException {
        public UnguardedException(Throwable throwable) {
            super(throwable);
        }
    }

    public static abstract class Transformer<L, R, T>
    implements Function<Either<L, R>, T> {
        public abstract T mapLeft(L var1);

        public abstract T mapRight(R var1);

        @Override
        public final T apply(Either<L, R> either) {
            return either.map(this);
        }
    }
}

