/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.base;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.twitter.common.base.CallableExceptionalSupplier;
import com.twitter.common.base.ExceptionalFunction;

public final class ExceptionalFunctions {
    private ExceptionalFunctions() {
    }

    public static <S, T, E extends Exception> CallableExceptionalSupplier<T, E> curry(final ExceptionalFunction<S, T, E> exceptionalFunction, final S s) {
        return new CallableExceptionalSupplier<T, E>(){

            @Override
            public T get() throws Exception {
                return exceptionalFunction.apply(s);
            }
        };
    }

    public static <T, E extends Exception> ExceptionalFunction<T, T, E> compose(final Iterable<ExceptionalFunction<T, T, E>> iterable) {
        return new ExceptionalFunction<T, T, E>(){

            @Override
            public T apply(T t) throws Exception {
                Object t2 = t;
                for (ExceptionalFunction exceptionalFunction : iterable) {
                    t2 = exceptionalFunction.apply(t2);
                }
                return t2;
            }
        };
    }

    public static <T, E extends Exception> ExceptionalFunction<T, T, E> compose(ExceptionalFunction<T, T, E> exceptionalFunction, ExceptionalFunction<T, T, E> ... exceptionalFunctionArray) {
        return ExceptionalFunctions.compose(ImmutableList.builder().add(exceptionalFunction).add((Object[])exceptionalFunctionArray).build());
    }

    public static <A, B, C, E extends Exception> ExceptionalFunction<A, C, E> compose(final ExceptionalFunction<B, C, ? extends E> exceptionalFunction, final ExceptionalFunction<A, ? extends B, ? extends E> exceptionalFunction2) {
        return new ExceptionalFunction<A, C, E>(){

            @Override
            public C apply(A a) throws Exception {
                return exceptionalFunction.apply(exceptionalFunction2.apply(a));
            }
        };
    }

    public static <S, T, E extends Exception> ExceptionalFunction<S, T, E> forFunction(final Function<S, T> function) {
        return new ExceptionalFunction<S, T, E>(){

            @Override
            public T apply(S s) {
                return function.apply(s);
            }
        };
    }

    public static <S, T, E extends Exception> ExceptionalFunction<S, T, E> constant(final T t) {
        return new ExceptionalFunction<S, T, E>(){

            @Override
            public T apply(S s) throws Exception {
                return t;
            }
        };
    }

    public static <S, T, E extends Exception> ExceptionalFunction<S, T, E> forException(final E e) {
        return new ExceptionalFunction<S, T, E>(){

            @Override
            public T apply(S s) throws Exception {
                throw e;
            }
        };
    }
}

