/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.base;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import org.apache.commons.lang.StringUtils;

public final class MorePreconditions {
    private static final String ARG_NOT_BLANK_MSG = "Argument cannot be blank";

    private MorePreconditions() {
    }

    public static String checkNotBlank(String string) {
        return MorePreconditions.checkNotBlank(string, ARG_NOT_BLANK_MSG, new Object[0]);
    }

    public static String checkNotBlank(String string, String string2, Object ... objectArray) {
        Preconditions.checkNotNull((Object)string, (String)string2, (Object[])objectArray);
        Preconditions.checkArgument((!StringUtils.isBlank((String)string) ? 1 : 0) != 0, (String)string2, (Object[])objectArray);
        return string;
    }

    public static <S, T extends Iterable<S>> T checkNotBlank(T t) {
        return MorePreconditions.checkNotBlank(t, ARG_NOT_BLANK_MSG, new Object[0]);
    }

    public static <S, T extends Iterable<S>> T checkNotBlank(T t, String string, Object ... objectArray) {
        Preconditions.checkNotNull(t, (String)string, (Object[])objectArray);
        Preconditions.checkArgument((!Iterables.isEmpty(t) ? 1 : 0) != 0, (String)string, (Object[])objectArray);
        return t;
    }

    public static double checkArgumentRange(double d, double d2, double d3, String string) {
        Preconditions.checkArgument((d2 <= d ? 1 : 0) != 0, (String)string, (Object[])new Object[]{d});
        Preconditions.checkArgument((d <= d3 ? 1 : 0) != 0, (String)string, (Object[])new Object[]{d});
        return d;
    }

    public static int checkArgumentRange(int n, int n2, int n3, String string) {
        Preconditions.checkArgument((n2 <= n ? 1 : 0) != 0, (String)string, (Object[])new Object[]{n});
        Preconditions.checkArgument((n <= n3 ? 1 : 0) != 0, (String)string, (Object[])new Object[]{n});
        return n;
    }

    public static boolean checkArguments(String string, Boolean ... booleanArray) {
        for (Boolean bl : booleanArray) {
            if (!bl.booleanValue()) continue;
            return true;
        }
        throw new IllegalArgumentException(string);
    }
}

