/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.base;

import com.google.common.base.Preconditions;
import com.twitter.common.base.Supplier;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import javax.annotation.Nullable;

public final class MoreSuppliers {
    private MoreSuppliers() {
    }

    public static <T> Supplier<T> of(final Class<? extends T> clazz) {
        Preconditions.checkNotNull(clazz);
        try {
            final Constructor<? extends T> constructor = MoreSuppliers.getNoArgConstructor(clazz);
            return new Supplier<T>(){

                @Override
                public T get() {
                    try {
                        return constructor.newInstance(new Object[0]);
                    }
                    catch (InstantiationException instantiationException) {
                        throw MoreSuppliers.instantiationFailed(instantiationException, clazz);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw MoreSuppliers.instantiationFailed(illegalAccessException, clazz);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw MoreSuppliers.instantiationFailed(invocationTargetException, clazz);
                    }
                }
            };
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException("No accessible no-arg constructor for " + clazz, noSuchMethodException);
        }
    }

    private static RuntimeException instantiationFailed(Exception exception, Object object) {
        return new RuntimeException("Could not create a new instance of type: " + object, exception);
    }

    private static <T> Constructor<T> getNoArgConstructor(Class<T> clazz) throws NoSuchMethodException {
        try {
            Constructor<T> constructor = clazz.getConstructor(new Class[0]);
            if (!MoreSuppliers.class.getPackage().equals(clazz.getPackage()) && !Modifier.isPublic(clazz.getModifiers())) {
                constructor.setAccessible(true);
            }
            return constructor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor;
        }
    }

    public static <T> Supplier<T> ofInstance(final @Nullable T t) {
        return new Supplier<T>(){

            @Override
            public T get() {
                return t;
            }
        };
    }
}

