/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.collections;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

public final class Multimaps {
    private Multimaps() {
    }

    public static <K, V> Multimap<K, V> prune(Multimap<K, V> multimap, Predicate<Collection<V>> predicate) {
        Preconditions.checkNotNull(multimap);
        Preconditions.checkNotNull(predicate);
        HashSet hashSet = Sets.newHashSet();
        for (Object object : multimap.keySet()) {
            if (predicate.apply((Object)multimap.get(object))) continue;
            hashSet.add(object);
        }
        ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
        for (Object e : hashSet) {
            arrayListMultimap.putAll(e, (Iterable)multimap.removeAll(e));
        }
        return arrayListMultimap;
    }

    public static <K, V> Multimap<K, V> prune(Multimap<K, V> multimap, final int n) {
        return Multimaps.prune(multimap, new Predicate<Collection<V>>(){

            public boolean apply(Collection<V> collection) {
                return collection.size() >= n;
            }
        });
    }

    public static <K> Set<K> getLargeGroups(Multimap<K, ?> multimap, int n) {
        HashSet hashSet = Sets.newHashSet();
        for (Object e : multimap.keySet()) {
            if (multimap.get(e).size() < n) continue;
            hashSet.add(e);
        }
        return hashSet;
    }

    public static <K> Set<K> getLargestGroups(Multimap<K, ?> multimap, int n) {
        class Grouping
        implements Comparable<Grouping> {
            private K key;
            private int size;

            public Grouping(K k, int n) {
                this.key = k;
                this.size = n;
            }

            public int hashCode() {
                return this.size;
            }

            @Override
            public int compareTo(Grouping grouping) {
                return this.size - grouping.size;
            }

            public boolean equals(Object object) {
                if (!(object instanceof Grouping)) {
                    return false;
                }
                Grouping grouping = (Grouping)object;
                return this.key.equals(grouping.key);
            }
        }
        TreeSet treeSet = Sets.newTreeSet();
        for (Object object : multimap.keySet()) {
            treeSet.add(new Grouping(object, multimap.get(object).size()));
            if (treeSet.size() <= n) continue;
            treeSet.remove(treeSet.first());
        }
        HashSet hashSet = Sets.newHashSet();
        for (Grouping grouping : treeSet) {
            hashSet.add(grouping.key);
        }
        return hashSet;
    }
}

