/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.collections;

import com.google.common.base.Function;
import javax.annotation.Nullable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class Pair<A, B> {
    @Nullable
    private final A first;
    @Nullable
    private final B second;

    public Pair(@Nullable A a, @Nullable B b) {
        this.first = a;
        this.second = b;
    }

    @Nullable
    public A getFirst() {
        return this.first;
    }

    @Nullable
    public B getSecond() {
        return this.second;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Pair)) {
            return false;
        }
        Pair pair = (Pair)object;
        return new EqualsBuilder().append(this.first, pair.first).append(this.second, pair.second).isEquals();
    }

    public String toString() {
        return String.format("(%s, %s)", this.getFirst(), this.getSecond());
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.first).append(this.second).toHashCode();
    }

    public static <S, T> Function<Pair<S, T>, S> first() {
        return new Function<Pair<S, T>, S>(){

            public S apply(Pair<S, T> pair) {
                return pair.first;
            }
        };
    }

    public static <S, T> Function<Pair<S, T>, T> second() {
        return new Function<Pair<S, T>, T>(){

            public T apply(Pair<S, T> pair) {
                return pair.second;
            }
        };
    }

    public static <A, B> Pair<A, B> of(@Nullable A a, @Nullable B b) {
        return new Pair<A, B>(a, b);
    }
}

