/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.util.logging;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.LogManager;

public class ResourceLoggingConfigurator {
    public static final String LOGGING_PROPERTIES_RESOURCE_PATH = "java.util.logging.config.resource";

    public ResourceLoggingConfigurator() throws IOException {
        String string = System.getProperty(LOGGING_PROPERTIES_RESOURCE_PATH, "/logging.properties");
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        Preconditions.checkNotNull((Object)inputStream, (String)"Could not locate logging config file at resource path: %s", (Object[])new Object[]{string});
        LogManager.getLogManager().readConfiguration(inputStream);
    }
}

