/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.metrics;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.twitter.common.base.MorePreconditions;
import com.twitter.common.metrics.HistogramInterface;
import com.twitter.common.metrics.MetricRegistry;
import com.twitter.common.metrics.Percentile;
import com.twitter.common.metrics.Snapshot;
import com.twitter.common.quantity.Amount;
import com.twitter.common.quantity.Data;
import com.twitter.common.quantity.Time;
import com.twitter.common.stats.Precision;
import com.twitter.common.stats.WindowedApproxHistogram;
import com.twitter.common.stats.WindowedStatistics;
import com.twitter.common.util.Clock;
import com.twitter.common.util.LowResClock;
import javax.annotation.Nullable;

public class Histogram
implements HistogramInterface {
    @VisibleForTesting
    public static final double[] DEFAULT_QUANTILES = new double[]{0.5, 0.9, 0.95, 0.99, 0.999, 0.9999};
    private final String name;
    private final com.twitter.common.stats.Histogram histogram;
    private final WindowedStatistics stats;
    private final double[] quantiles;

    public Histogram(String string, Amount<Long, Time> amount, int n, @Nullable Amount<Long, Data> amount2, @Nullable Precision precision, double[] dArray, Clock clock, @Nullable MetricRegistry metricRegistry) {
        Preconditions.checkArgument((boolean)(precision != null ^ amount2 != null), (Object)"You must specify either memory or precision constraint but not both!");
        Preconditions.checkNotNull(amount);
        Preconditions.checkArgument((0 < n ? 1 : 0) != 0);
        for (double d : dArray) {
            Preconditions.checkArgument((0.0 <= d && d <= 1.0 ? 1 : 0) != 0);
        }
        Preconditions.checkNotNull((Object)clock);
        this.name = MorePreconditions.checkNotBlank((String)string);
        this.quantiles = (double[])Preconditions.checkNotNull((Object)dArray);
        this.histogram = amount2 != null ? new WindowedApproxHistogram(amount, n, amount2, clock) : new WindowedApproxHistogram(amount, n, precision, clock);
        this.stats = new WindowedStatistics(amount, n, clock);
        if (metricRegistry != null) {
            metricRegistry.registerHistogram(this);
        }
    }

    public Histogram(String string, Amount<Long, Time> amount, int n, @Nullable Amount<Long, Data> amount2, @Nullable Precision precision, double[] dArray, Clock clock) {
        this(string, amount, n, amount2, precision, dArray, clock, null);
    }

    public Histogram(String string) {
        this(string, (Amount<Long, Time>)WindowedApproxHistogram.DEFAULT_WINDOW, 3, (Amount<Long, Data>)WindowedApproxHistogram.DEFAULT_MAX_MEMORY, null, DEFAULT_QUANTILES, LowResClock.DEFAULT, null);
    }

    @Deprecated
    public Histogram(String string, MetricRegistry metricRegistry) {
        this(string, (Amount<Long, Time>)WindowedApproxHistogram.DEFAULT_WINDOW, 3, (Amount<Long, Data>)WindowedApproxHistogram.DEFAULT_MAX_MEMORY, null, DEFAULT_QUANTILES, LowResClock.DEFAULT, metricRegistry);
    }

    public Histogram(String string, Precision precision) {
        this(string, (Amount<Long, Time>)WindowedApproxHistogram.DEFAULT_WINDOW, 3, null, precision, DEFAULT_QUANTILES, LowResClock.DEFAULT, null);
    }

    public Histogram(String string, Amount<Long, Data> amount) {
        this(string, (Amount<Long, Time>)WindowedApproxHistogram.DEFAULT_WINDOW, 3, amount, null, DEFAULT_QUANTILES, LowResClock.DEFAULT, null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public synchronized void clear() {
        this.stats.clear();
        this.histogram.clear();
    }

    @Override
    public synchronized void add(long l) {
        this.stats.accumulate(l);
        this.histogram.add(l);
    }

    @Override
    public synchronized Snapshot snapshot() {
        this.stats.refresh();
        final long l = this.stats.populationSize();
        final long l2 = this.stats.sum();
        final double d = this.stats.mean();
        final long l3 = l == 0L ? 0L : this.stats.min();
        final long l4 = l == 0L ? 0L : this.stats.max();
        final double d2 = this.stats.standardDeviation();
        final Percentile[] percentileArray = new Percentile[this.quantiles.length];
        long[] lArray = this.histogram.getQuantiles(this.quantiles);
        for (int i = 0; i < percentileArray.length; ++i) {
            percentileArray[i] = new Percentile(this.quantiles[i], lArray[i]);
        }
        return new Snapshot(){

            @Override
            public long count() {
                return l;
            }

            @Override
            public long sum() {
                return l2;
            }

            @Override
            public double avg() {
                return d;
            }

            @Override
            public long min() {
                return l3;
            }

            @Override
            public long max() {
                return l4;
            }

            @Override
            public double stddev() {
                return d2;
            }

            @Override
            public Percentile[] percentiles() {
                return percentileArray;
            }
        };
    }
}

