/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.metrics;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.primitives.Primitives;
import com.sun.management.OperatingSystemMXBean;
import com.sun.management.UnixOperatingSystemMXBean;
import com.twitter.common.metrics.AbstractGauge;
import com.twitter.common.metrics.MetricRegistry;
import com.twitter.common.metrics.Metrics;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public final class JvmStats {
    private JvmStats() {
    }

    private static Multimap<String, AbstractGauge<Long>> buildJava17Gauges() {
        ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
        try {
            Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass("java.lang.management.BufferPoolMXBean");
            Method method = ManagementFactory.class.getMethod("getPlatformMXBeans", Class.class);
            List list = (List)method.invoke(null, clazz);
            for (Object e : list) {
                String string = (String)clazz.getMethod("getName", new Class[0]).invoke(e, new Object[0]);
                arrayListMultimap.put((Object)string, JvmStats.reflectMethodToGauge("count", clazz, "getCount", e));
                arrayListMultimap.put((Object)string, JvmStats.reflectMethodToGauge("used", clazz, "getMemoryUsed", e));
                arrayListMultimap.put((Object)string, JvmStats.reflectMethodToGauge("max", clazz, "getTotalCapacity", e));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return arrayListMultimap;
    }

    private static AbstractGauge<Long> reflectMethodToGauge(String string, Class<?> clazz, String string2, final Object object) throws NoSuchMethodException, IllegalArgumentException {
        final Method method = clazz.getMethod(string2, new Class[0]);
        if (!Long.class.isAssignableFrom(Primitives.wrap(method.getReturnType()))) {
            throw new IllegalArgumentException("mx bean method " + string2 + " can't be stored as Long metric");
        }
        return new AbstractGauge<Long>(string){

            @Override
            public Long read() {
                try {
                    return (Long)method.invoke(object, new Object[0]);
                }
                catch (IllegalAccessException illegalAccessException) {
                    return 0L;
                }
                catch (InvocationTargetException invocationTargetException) {
                    return 0L;
                }
            }
        };
    }

    private static void registerMemoryStats(MetricRegistry metricRegistry, final MemoryReporter memoryReporter) {
        if (memoryReporter.getUsage() != null) {
            metricRegistry.registerGauge(new AbstractGauge<Long>("committed"){

                @Override
                public Long read() {
                    return memoryReporter.getUsage().getCommitted();
                }
            });
            metricRegistry.registerGauge(new AbstractGauge<Long>("max"){

                @Override
                public Long read() {
                    return memoryReporter.getUsage().getMax();
                }
            });
            metricRegistry.registerGauge(new AbstractGauge<Long>("used"){

                @Override
                public Long read() {
                    return memoryReporter.getUsage().getUsed();
                }
            });
        }
    }

    public static void register(MetricRegistry metricRegistry) {
        Object object;
        Object object22;
        Object object3;
        Multimap<String, AbstractGauge<Long>> multimap;
        Object object4;
        MetricRegistry metricRegistry2 = metricRegistry.scope("jvm");
        final MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        MetricRegistry metricRegistry3 = metricRegistry2.scope("heap");
        JvmStats.registerMemoryStats(metricRegistry3, new MemoryReporter(){

            @Override
            public MemoryUsage getUsage() {
                return memoryMXBean.getHeapMemoryUsage();
            }
        });
        MetricRegistry metricRegistry4 = metricRegistry2.scope("nonheap");
        JvmStats.registerMemoryStats(metricRegistry4, new MemoryReporter(){

            @Override
            public MemoryUsage getUsage() {
                return memoryMXBean.getNonHeapMemoryUsage();
            }
        });
        final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        MetricRegistry metricRegistry5 = metricRegistry2.scope("thread");
        metricRegistry5.registerGauge(new AbstractGauge<Integer>("daemon_count"){

            @Override
            public Integer read() {
                return threadMXBean.getDaemonThreadCount();
            }
        });
        metricRegistry5.registerGauge(new AbstractGauge<Integer>("count"){

            @Override
            public Integer read() {
                return threadMXBean.getThreadCount();
            }
        });
        metricRegistry5.registerGauge(new AbstractGauge<Integer>("peak_count"){

            @Override
            public Integer read() {
                return threadMXBean.getPeakThreadCount();
            }
        });
        final ClassLoadingMXBean classLoadingMXBean = ManagementFactory.getClassLoadingMXBean();
        metricRegistry2.registerGauge(new AbstractGauge<Integer>("classes_loaded"){

            @Override
            public Integer read() {
                return classLoadingMXBean.getLoadedClassCount();
            }
        });
        metricRegistry2.registerGauge(new AbstractGauge<Long>("total_classes_loaded"){

            @Override
            public Long read() {
                return classLoadingMXBean.getTotalLoadedClassCount();
            }
        });
        metricRegistry2.registerGauge(new AbstractGauge<Long>("classes_unloaded"){

            @Override
            public Long read() {
                return classLoadingMXBean.getUnloadedClassCount();
            }
        });
        final RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        metricRegistry2.registerGauge(new AbstractGauge<Long>("start_time"){

            @Override
            public Long read() {
                return runtimeMXBean.getStartTime();
            }
        });
        metricRegistry2.registerGauge(new AbstractGauge<Long>("uptime"){

            @Override
            public Long read() {
                return runtimeMXBean.getUptime();
            }
        });
        final java.lang.management.OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        metricRegistry2.registerGauge(new AbstractGauge<Integer>("num_cpus"){

            @Override
            public Integer read() {
                return operatingSystemMXBean.getAvailableProcessors();
            }
        });
        if (operatingSystemMXBean instanceof OperatingSystemMXBean) {
            object4 = (OperatingSystemMXBean)operatingSystemMXBean;
            metricRegistry2.registerGauge(new AbstractGauge<Long>("free_physical_memory", (OperatingSystemMXBean)object4){
                final /* synthetic */ OperatingSystemMXBean val$sunOsMbean;
                {
                    this.val$sunOsMbean = operatingSystemMXBean;
                    super(string);
                }

                @Override
                public Long read() {
                    return this.val$sunOsMbean.getFreePhysicalMemorySize();
                }
            });
            metricRegistry2.registerGauge(new AbstractGauge<Long>("free_swap", (OperatingSystemMXBean)object4){
                final /* synthetic */ OperatingSystemMXBean val$sunOsMbean;
                {
                    this.val$sunOsMbean = operatingSystemMXBean;
                    super(string);
                }

                @Override
                public Long read() {
                    return this.val$sunOsMbean.getFreeSwapSpaceSize();
                }
            });
            metricRegistry2.registerGauge(new AbstractGauge<Long>("process_cpu_time", (OperatingSystemMXBean)object4){
                final /* synthetic */ OperatingSystemMXBean val$sunOsMbean;
                {
                    this.val$sunOsMbean = operatingSystemMXBean;
                    super(string);
                }

                @Override
                public Long read() {
                    return this.val$sunOsMbean.getProcessCpuTime();
                }
            });
        }
        if (operatingSystemMXBean instanceof UnixOperatingSystemMXBean) {
            object4 = (UnixOperatingSystemMXBean)operatingSystemMXBean;
            metricRegistry2.registerGauge(new AbstractGauge<Long>("fd_count", (UnixOperatingSystemMXBean)object4){
                final /* synthetic */ UnixOperatingSystemMXBean val$unix;
                {
                    this.val$unix = unixOperatingSystemMXBean;
                    super(string);
                }

                @Override
                public Long read() {
                    return this.val$unix.getOpenFileDescriptorCount();
                }
            });
            metricRegistry2.registerGauge(new AbstractGauge<Long>("fd_limit", (UnixOperatingSystemMXBean)object4){
                final /* synthetic */ UnixOperatingSystemMXBean val$unix;
                {
                    this.val$unix = unixOperatingSystemMXBean;
                    super(string);
                }

                @Override
                public Long read() {
                    return this.val$unix.getMaxFileDescriptorCount();
                }
            });
        }
        object4 = ManagementFactory.getMemoryPoolMXBeans();
        MetricRegistry metricRegistry6 = metricRegistry2.scope("mem");
        MetricRegistry metricRegistry7 = metricRegistry6.scope("current");
        MetricRegistry metricRegistry8 = metricRegistry6.scope("postGC");
        Object object5 = object4.iterator();
        while (object5.hasNext()) {
            multimap = (Multimap<String, AbstractGauge<Long>>)object5.next();
            object3 = Metrics.normalizeName(multimap.getName());
            JvmStats.registerMemoryStats(metricRegistry7.scope((String)object3), new MemoryReporter((MemoryPoolMXBean)multimap){
                final /* synthetic */ MemoryPoolMXBean val$pool;
                {
                    this.val$pool = memoryPoolMXBean;
                }

                @Override
                public MemoryUsage getUsage() {
                    return this.val$pool.getUsage();
                }
            });
            JvmStats.registerMemoryStats(metricRegistry8.scope((String)object3), new MemoryReporter((MemoryPoolMXBean)multimap){
                final /* synthetic */ MemoryPoolMXBean val$pool;
                {
                    this.val$pool = memoryPoolMXBean;
                }

                @Override
                public MemoryUsage getUsage() {
                    return this.val$pool.getCollectionUsage();
                }
            });
        }
        metricRegistry7.registerGauge(new AbstractGauge<Long>("used", (List)object4){
            final /* synthetic */ List val$memPool;
            {
                this.val$memPool = list;
                super(string);
            }

            @Override
            public Long read() {
                long l = 0L;
                for (MemoryPoolMXBean memoryPoolMXBean : this.val$memPool) {
                    MemoryUsage memoryUsage = memoryPoolMXBean.getUsage();
                    if (memoryUsage == null) continue;
                    l += memoryUsage.getUsed();
                }
                return l;
            }
        });
        object5 = new AbstractGauge<Long>("used", (List)object4){
            final /* synthetic */ List val$memPool;
            {
                this.val$memPool = list;
                super(string);
            }

            @Override
            public Long read() {
                long l = 0L;
                for (MemoryPoolMXBean memoryPoolMXBean : this.val$memPool) {
                    MemoryUsage memoryUsage = memoryPoolMXBean.getCollectionUsage();
                    if (memoryUsage == null) continue;
                    l += memoryUsage.getUsed();
                }
                return l;
            }
        };
        metricRegistry8.registerGauge(object5);
        multimap = JvmStats.buildJava17Gauges();
        if (!multimap.isEmpty()) {
            object3 = metricRegistry2.scope("buffer");
            for (Object object22 : multimap.keySet()) {
                object = object3.scope((String)object22);
                for (Object object6 : multimap.get(object22)) {
                    object.registerGauge(object6);
                }
            }
        }
        object3 = ManagementFactory.getGarbageCollectorMXBeans();
        MetricRegistry metricRegistry9 = metricRegistry2.scope("gc");
        object22 = object3.iterator();
        while (object22.hasNext()) {
            Object object6;
            object = (GarbageCollectorMXBean)object22.next();
            String string = Metrics.normalizeName(object.getName());
            object6 = metricRegistry6.scope(string);
            object6.registerGauge(new AbstractGauge<Long>("cycles", (GarbageCollectorMXBean)object){
                final /* synthetic */ GarbageCollectorMXBean val$gc;
                {
                    this.val$gc = garbageCollectorMXBean;
                    super(string);
                }

                @Override
                public Long read() {
                    return this.val$gc.getCollectionCount();
                }
            });
            object6.registerGauge(new AbstractGauge<Long>("msec", (GarbageCollectorMXBean)object){
                final /* synthetic */ GarbageCollectorMXBean val$gc;
                {
                    this.val$gc = garbageCollectorMXBean;
                    super(string);
                }

                @Override
                public Long read() {
                    return this.val$gc.getCollectionTime();
                }
            });
        }
        metricRegistry9.registerGauge(new AbstractGauge<Long>("cycles", (List)object3){
            final /* synthetic */ List val$gcPool;
            {
                this.val$gcPool = list;
                super(string);
            }

            @Override
            public Long read() {
                long l = 0L;
                for (GarbageCollectorMXBean garbageCollectorMXBean : this.val$gcPool) {
                    long l2 = garbageCollectorMXBean.getCollectionCount();
                    if (l2 <= 0L) continue;
                    l += l2;
                }
                return l;
            }
        });
        metricRegistry9.registerGauge(new AbstractGauge<Long>("msec", (List)object3){
            final /* synthetic */ List val$gcPool;
            {
                this.val$gcPool = list;
                super(string);
            }

            @Override
            public Long read() {
                long l = 0L;
                for (GarbageCollectorMXBean garbageCollectorMXBean : this.val$gcPool) {
                    long l2 = garbageCollectorMXBean.getCollectionTime();
                    if (l2 <= 0L) continue;
                    l += l2;
                }
                return l;
            }
        });
    }

    private static interface MemoryReporter {
        public MemoryUsage getUsage();
    }
}

