/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.metrics;

import com.google.common.base.Preconditions;
import com.twitter.common.metrics.MetricSampler;
import com.twitter.common.quantity.Amount;
import com.twitter.common.quantity.Time;
import com.twitter.common.quantity.Unit;
import com.twitter.common.util.concurrent.ExecutorServiceShutdown;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;

public class MetricPoller {
    private static final Logger LOG = Logger.getLogger(MetricPoller.class.getName());
    private static final Amount<Long, Time> SHUTDOWN_GRACE_PERIOD = Amount.of((long)2L, (Unit)Time.SECONDS);
    private final MetricSampler sampler;
    private final ScheduledExecutorService executor;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final AtomicBoolean stopped = new AtomicBoolean(false);

    public MetricPoller(MetricSampler metricSampler, ScheduledExecutorService scheduledExecutorService) {
        this.sampler = (MetricSampler)Preconditions.checkNotNull((Object)metricSampler);
        this.executor = (ScheduledExecutorService)Preconditions.checkNotNull((Object)scheduledExecutorService);
    }

    public void start(Amount<Long, Time> amount) {
        Preconditions.checkNotNull(amount);
        Preconditions.checkArgument(((Long)amount.getValue() > 0L ? 1 : 0) != 0, (Object)"Poll interval must be positive");
        Preconditions.checkState((boolean)this.started.compareAndSet(false, true), (Object)"Poller is already started.");
        long l = (Long)amount.as((Unit)Time.MILLISECONDS);
        this.executor.scheduleAtFixedRate(this.sampler, l, l, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        if (this.stopped.compareAndSet(false, true)) {
            new ExecutorServiceShutdown((ExecutorService)this.executor, SHUTDOWN_GRACE_PERIOD).execute();
        } else {
            LOG.warning("Poller is already stopped, subsequent calls ignored.");
        }
    }
}

