/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.metrics;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.twitter.common.metrics.Events;
import com.twitter.common.metrics.MetricListener;
import com.twitter.common.metrics.MetricProvider;
import com.twitter.common.metrics.MetricRegistry;
import com.twitter.common.util.Clock;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class MetricSampler
implements Runnable {
    private final MetricProvider metricProvider;
    private final List<MetricListener> listeners;
    private final Clock clock;
    private final Events events;

    @VisibleForTesting
    public MetricSampler(MetricProvider metricProvider, Iterable<MetricListener> iterable, MetricRegistry metricRegistry, Clock clock) {
        this.metricProvider = (MetricProvider)Preconditions.checkNotNull((Object)metricProvider);
        this.listeners = new CopyOnWriteArrayList<MetricListener>((Collection<MetricListener>)ImmutableList.copyOf(iterable));
        this.clock = (Clock)Preconditions.checkNotNull((Object)clock);
        Preconditions.checkNotNull((Object)metricRegistry);
        this.events = new Events("metric_samples", "metric_sample_delay", metricRegistry);
    }

    public void addListener(MetricListener metricListener) {
        this.listeners.add(metricListener);
    }

    @Override
    public void run() {
        long l = this.clock.nowNanos();
        Map<String, Number> map = this.metricProvider.sample();
        this.events.accumulate(this.clock.nowNanos() - l);
        for (MetricListener metricListener : this.listeners) {
            metricListener.updateStats(map);
        }
    }
}

