/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.metrics;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.twitter.common.metrics.Counter;
import com.twitter.common.metrics.Gauge;
import com.twitter.common.metrics.Histogram;
import com.twitter.common.metrics.HistogramInterface;
import com.twitter.common.metrics.MetricCollisionException;
import com.twitter.common.metrics.MetricProvider;
import com.twitter.common.metrics.MetricRegistry;
import com.twitter.common.metrics.Percentile;
import com.twitter.common.metrics.ScopedRegistry;
import com.twitter.common.metrics.Snapshot;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Metrics
implements MetricRegistry,
MetricProvider {
    private static final Metrics ROOT = new Metrics();
    private static final Logger LOG = Logger.getLogger(Metrics.class.getName());
    private final Map<String, Gauge<?>> gauges = Maps.newConcurrentMap();
    private final ConcurrentMap<String, CounterWithAdder> counters = Maps.newConcurrentMap();
    private final ConcurrentMap<String, HistogramInterface> histograms = Maps.newConcurrentMap();

    private Metrics() {
    }

    public static String normalizeName(String string) {
        return string.replaceAll("\\W+", "_");
    }

    public static String specializeName(String string) {
        return string + "@m";
    }

    public static Metrics createDetached() {
        return new Metrics();
    }

    public static Metrics root() {
        return ROOT;
    }

    @Override
    public MetricRegistry scope(String string) {
        return new ScopedRegistry(this, string);
    }

    @Override
    public <T extends Number> void register(Gauge<T> gauge) {
        this.registerGauge(gauge);
    }

    @Override
    public synchronized <T extends Number> Gauge<T> registerGauge(Gauge<T> gauge) {
        String string = gauge.getName();
        if (this.counters.containsKey(string)) {
            throw new MetricCollisionException("A counter with the name " + string + " has already been defined");
        }
        this.gauges.put(string, gauge);
        return gauge;
    }

    @Override
    public synchronized boolean unregister(Gauge<?> gauge) {
        String string = gauge.getName();
        return this.gauges.remove(string) != null;
    }

    @Override
    public Counter registerCounter(String string) {
        return this.createCounter(string);
    }

    @Override
    public synchronized Counter createCounter(String string) {
        if (this.gauges.containsKey(string)) {
            throw new MetricCollisionException("A gauge with the name " + string + " has already been defined");
        }
        CounterWithAdder counterWithAdder = new CounterWithAdder(string);
        CounterWithAdder counterWithAdder2 = this.counters.putIfAbsent(string, counterWithAdder);
        if (counterWithAdder2 == null) {
            return counterWithAdder;
        }
        return counterWithAdder2;
    }

    @Override
    public synchronized boolean unregister(Counter counter) {
        String string = counter.getName();
        return this.counters.remove(string) != null;
    }

    @Override
    public HistogramInterface createHistogram(String string) {
        return this.registerHistogram(new Histogram(string));
    }

    @Override
    public synchronized HistogramInterface registerHistogram(HistogramInterface histogramInterface) {
        String string = histogramInterface.getName();
        HistogramInterface histogramInterface2 = this.histograms.putIfAbsent(string, histogramInterface);
        if (histogramInterface2 == null) {
            return histogramInterface;
        }
        return histogramInterface2;
    }

    @Override
    public synchronized boolean unregister(HistogramInterface histogramInterface) {
        String string = histogramInterface.getName();
        return this.histograms.remove(string) != null;
    }

    @Override
    public synchronized boolean unregister(String string) {
        return this.gauges.remove(string) != null || this.counters.remove(string) != null || this.histograms.remove(string) != null;
    }

    @Override
    public Map<String, Number> sampleGauges() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<String, Gauge<?>> entry : this.gauges.entrySet()) {
            Gauge<?> gauge = entry.getValue();
            try {
                builder.put((Object)entry.getKey(), gauge.read());
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, "exception while sampling gauge '" + entry.getKey() + "'", exception);
            }
        }
        return builder.build();
    }

    @Override
    public Map<String, Number> sampleCounters() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : this.counters.entrySet()) {
            builder.put(entry.getKey(), (Object)((CounterWithAdder)entry.getValue()).adder.sum());
        }
        return builder.build();
    }

    @Override
    public Map<String, Snapshot> sampleHistograms() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (HistogramInterface histogramInterface : this.histograms.values()) {
            Snapshot snapshot = histogramInterface.snapshot();
            builder.put((Object)histogramInterface.getName(), (Object)snapshot);
        }
        return builder.build();
    }

    @Override
    public Map<String, Number> sample() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll(this.sampleGauges());
        builder.putAll(this.sampleCounters());
        for (Map.Entry<String, Snapshot> entry : this.sampleHistograms().entrySet()) {
            String string = entry.getKey();
            Snapshot snapshot = entry.getValue();
            builder.put((Object)Metrics.named(string, "count"), (Object)snapshot.count());
            builder.put((Object)Metrics.named(string, "sum"), (Object)snapshot.sum());
            builder.put((Object)Metrics.named(string, "avg"), (Object)snapshot.avg());
            builder.put((Object)Metrics.named(string, "min"), (Object)snapshot.min());
            builder.put((Object)Metrics.named(string, "max"), (Object)snapshot.max());
            builder.put((Object)Metrics.named(string, "stddev"), (Object)snapshot.stddev());
            for (Percentile percentile : snapshot.percentiles()) {
                String string2 = Metrics.named(string, Metrics.gaugeName(percentile.getQuantile()));
                builder.put((Object)string2, (Object)percentile.getValue());
            }
        }
        return builder.build();
    }

    private static String named(String string, String string2) {
        return string + "." + string2;
    }

    private static String gaugeName(double d) {
        String string = "p" + (int)(d * 10000.0);
        if (3 < string.length() && "00".equals(string.substring(3))) {
            string = string.substring(0, 3);
        }
        return string;
    }

    private static final class CounterWithAdder
    implements Counter {
        private final String name;
        private final LongAdder adder;

        private CounterWithAdder(String string) {
            this.name = string;
            this.adder = new LongAdder();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void increment() {
            this.adder.increment();
        }

        @Override
        public void add(long l) {
            this.adder.add(l);
        }
    }
}

